/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.cheaptime.score;

import java.math.BigDecimal;

public final class CheapTimeCostCalculator {
    public static final long MICROS_PER_ONE_AS_LONG = 100000000000L;
    public static final double MICROS_PER_ONE_AS_DOUBLE = 1.0E11;
    public static final BigDecimal MICROS_PER_ONE_AS_BIG_DECIMAL = new BigDecimal(100000000000L);

    public static long toMicroCost(long cost) {
        return cost * 100000000000L;
    }

    public static long parseMicroCost(String costString) {
        BigDecimal costBigDecimal = new BigDecimal(costString);
        if (costBigDecimal.scale() > 11) {
            throw new IllegalArgumentException("The costString (" + costString + ") has a scale (" + costBigDecimal.scale() + ") higher than 10.");
        }
        costBigDecimal = costBigDecimal.setScale(11);
        return costBigDecimal.multiply(MICROS_PER_ONE_AS_BIG_DECIMAL).longValueExact();
    }

    public static long multiplyTwoMicros(long aMicros, long bMicros) {
        double aDouble = (double)aMicros / 1.0E11;
        double bDouble = (double)bMicros / 1.0E11;
        double result = aDouble * bDouble;
        return Math.round(result * 1.0E11);
    }

    public static long divideTwoMicros(long aMicros, long bMicros) {
        double aDouble = (double)aMicros / 1.0E11;
        double bDouble = (double)bMicros / 1.0E11;
        double result = aDouble / bDouble;
        return Math.round(result * 1.0E11);
    }

    private CheapTimeCostCalculator() {
    }
}

