/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.cloudbalancing.swingui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.optaplanner.examples.cloudbalancing.domain.CloudBalance;
import org.optaplanner.examples.cloudbalancing.domain.CloudComputer;
import org.optaplanner.examples.cloudbalancing.domain.CloudProcess;
import org.optaplanner.examples.cloudbalancing.swingui.CloudComputerPanel;
import org.optaplanner.examples.cloudbalancing.swingui.realtime.AddComputerProblemChange;
import org.optaplanner.examples.cloudbalancing.swingui.realtime.AddProcessProblemChange;
import org.optaplanner.examples.cloudbalancing.swingui.realtime.DeleteComputerProblemChange;
import org.optaplanner.examples.cloudbalancing.swingui.realtime.DeleteProcessProblemChange;
import org.optaplanner.examples.common.swingui.SolutionPanel;
import org.optaplanner.examples.common.swingui.components.LabeledComboBoxRenderer;
import org.optaplanner.swing.impl.SwingUtils;
import org.optaplanner.swing.impl.TangoColorFactory;

public class CloudBalancingPanel
extends SolutionPanel<CloudBalance> {
    public static final String LOGO_PATH = "/org/optaplanner/examples/cloudbalancing/swingui/cloudBalancingLogo.png";
    private final TangoColorFactory processColorFactory = new TangoColorFactory();
    private final ImageIcon cloudComputerIcon = new ImageIcon(this.getClass().getResource("cloudComputer.png"));
    private final ImageIcon addCloudComputerIcon = new ImageIcon(this.getClass().getResource("addCloudComputer.png"));
    private final ImageIcon deleteCloudComputerIcon = new ImageIcon(this.getClass().getResource("deleteCloudComputer.png"));
    private final ImageIcon cloudProcessIcon = new ImageIcon(this.getClass().getResource("cloudProcess.png"));
    private final ImageIcon addCloudProcessIcon = new ImageIcon(this.getClass().getResource("addCloudProcess.png"));
    private final ImageIcon deleteCloudProcessIcon = new ImageIcon(this.getClass().getResource("deleteCloudProcess.png"));
    private JPanel computersPanel;
    private CloudComputerPanel unassignedPanel;
    private Map<CloudComputer, CloudComputerPanel> computerToPanelMap;
    private int maximumComputerCpuPower;
    private int maximumComputerMemory;
    private int maximumComputerNetworkBandwidth;

    public CloudBalancingPanel() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        JPanel headerPanel = this.createHeaderPanel();
        JPanel computersPanel = this.createComputersPanel();
        layout.setHorizontalGroup(layout.createParallelGroup().addComponent(headerPanel).addComponent(computersPanel));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(headerPanel, -2, -2, -2).addComponent(computersPanel, -2, -2, -2));
    }

    public Color getCloudProcessColor(CloudProcess process) {
        return this.processColorFactory.pickColor((Object)process.getLabel());
    }

    public ImageIcon getCloudComputerIcon() {
        return this.cloudComputerIcon;
    }

    public ImageIcon getAddCloudComputerIcon() {
        return this.addCloudComputerIcon;
    }

    public ImageIcon getDeleteCloudComputerIcon() {
        return this.deleteCloudComputerIcon;
    }

    public ImageIcon getCloudProcessIcon() {
        return this.cloudProcessIcon;
    }

    public ImageIcon getAddCloudProcessIcon() {
        return this.addCloudProcessIcon;
    }

    public ImageIcon getDeleteCloudProcessIcon() {
        return this.deleteCloudProcessIcon;
    }

    public int getMaximumComputerCpuPower() {
        return this.maximumComputerCpuPower;
    }

    public int getMaximumComputerMemory() {
        return this.maximumComputerMemory;
    }

    public int getMaximumComputerNetworkBandwidth() {
        return this.maximumComputerNetworkBandwidth;
    }

    private JPanel createHeaderPanel() {
        JPanel headerPanel = new JPanel(new GridLayout(0, 5));
        JPanel addPanel = new JPanel(new GridLayout());
        JButton addComputerButton = SwingUtils.makeSmallButton((JButton)new JButton(this.addCloudComputerIcon));
        addComputerButton.setToolTipText("Add computer");
        addComputerButton.addActionListener(e -> {
            CloudComputer computer = new CloudComputer();
            computer.setCpuPower(12);
            computer.setMemory(32);
            computer.setNetworkBandwidth(12);
            computer.setCost(1400);
            this.addComputer(computer);
        });
        addPanel.add(addComputerButton);
        JButton addProcessButton = SwingUtils.makeSmallButton((JButton)new JButton(this.addCloudProcessIcon));
        addProcessButton.setToolTipText("Add process");
        addProcessButton.addActionListener(e -> {
            CloudProcess process = new CloudProcess();
            process.setRequiredCpuPower(3);
            process.setRequiredMemory(8);
            process.setRequiredNetworkBandwidth(3);
            this.addProcess(process);
        });
        addPanel.add(addProcessButton);
        JPanel cornerPanel = new JPanel(new BorderLayout());
        cornerPanel.add((Component)addPanel, "East");
        headerPanel.add(cornerPanel);
        JLabel cpuPowerLabel = new JLabel("CPU power");
        headerPanel.add(cpuPowerLabel);
        JLabel memoryLabel = new JLabel("Memory");
        headerPanel.add(memoryLabel);
        JLabel networkBandwidthLabel = new JLabel("Network bandwidth");
        headerPanel.add(networkBandwidthLabel);
        JLabel costLabel = new JLabel("Cost");
        headerPanel.add(costLabel);
        return headerPanel;
    }

    private JPanel createComputersPanel() {
        this.computersPanel = new JPanel(new GridLayout(0, 1));
        this.computerToPanelMap = new LinkedHashMap<CloudComputer, CloudComputerPanel>();
        return this.computersPanel;
    }

    @Override
    public void resetPanel(CloudBalance cloudBalance) {
        this.maximumComputerCpuPower = 0;
        this.maximumComputerMemory = 0;
        this.maximumComputerNetworkBandwidth = 0;
        for (CloudComputer computer : cloudBalance.getComputerList()) {
            if (computer.getCpuPower() > this.maximumComputerCpuPower) {
                this.maximumComputerCpuPower = computer.getCpuPower();
            }
            if (computer.getMemory() > this.maximumComputerMemory) {
                this.maximumComputerMemory = computer.getMemory();
            }
            if (computer.getNetworkBandwidth() <= this.maximumComputerNetworkBandwidth) continue;
            this.maximumComputerNetworkBandwidth = computer.getNetworkBandwidth();
        }
        for (CloudComputerPanel computerPanel : this.computerToPanelMap.values()) {
            if (computerPanel.getComputer() == null) continue;
            this.computersPanel.remove(computerPanel);
        }
        this.computerToPanelMap.clear();
        this.computersPanel.removeAll();
        this.unassignedPanel = new CloudComputerPanel(this, null);
        this.computersPanel.add(this.unassignedPanel);
        this.computerToPanelMap.put(null, this.unassignedPanel);
        this.updatePanel(cloudBalance);
    }

    @Override
    public void updatePanel(CloudBalance cloudBalance) {
        LinkedHashSet<CloudComputer> deadCloudComputerSet = new LinkedHashSet<CloudComputer>(this.computerToPanelMap.keySet());
        deadCloudComputerSet.remove(null);
        for (CloudComputer computer : cloudBalance.getComputerList()) {
            deadCloudComputerSet.remove(computer);
            CloudComputerPanel computerPanel = this.computerToPanelMap.get(computer);
            if (computerPanel == null) {
                computerPanel = new CloudComputerPanel(this, computer);
                this.computersPanel.add(computerPanel);
                this.computerToPanelMap.put(computer, computerPanel);
            }
            computerPanel.clearProcesses();
        }
        this.unassignedPanel.clearProcesses();
        for (CloudProcess process : cloudBalance.getProcessList()) {
            CloudComputer computer = process.getComputer();
            CloudComputerPanel computerPanel = this.computerToPanelMap.get(computer);
            computerPanel.addProcess(process);
        }
        for (CloudComputer deadComputer : deadCloudComputerSet) {
            CloudComputerPanel deadComputerPanel = this.computerToPanelMap.remove(deadComputer);
            this.computersPanel.remove(deadComputerPanel);
        }
        for (CloudComputerPanel computerPanel : this.computerToPanelMap.values()) {
            computerPanel.update();
        }
        this.computersPanel.validate();
    }

    public void addComputer(CloudComputer computer) {
        this.logger.info("Scheduling addition of computer ({}).", (Object)computer);
        this.doProblemChange(new AddComputerProblemChange(computer));
    }

    public void deleteComputer(CloudComputer computer) {
        this.logger.info("Scheduling delete of computer ({}).", (Object)computer);
        this.doProblemChange(new DeleteComputerProblemChange(computer));
    }

    public void addProcess(CloudProcess process) {
        this.logger.info("Scheduling addition of process ({}).", (Object)process);
        this.doProblemChange(new AddProcessProblemChange(process));
    }

    public void deleteProcess(CloudProcess process) {
        this.logger.info("Scheduling delete of process ({}).", (Object)process);
        this.doProblemChange(new DeleteProcessProblemChange(process));
    }

    public JButton createButton(CloudProcess process, Runnable removeAction) {
        return SwingUtils.makeSmallButton((JButton)new JButton(new CloudProcessAction(process, removeAction)));
    }

    private class CloudProcessAction
    extends AbstractAction {
        private final CloudProcess process;
        private final Runnable removeAction;

        public CloudProcessAction(CloudProcess process, Runnable removeAction) {
            super(process.getLabel());
            this.process = process;
            this.removeAction = removeAction;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JPanel listFieldsPanel = new JPanel(new GridLayout(1, 2));
            listFieldsPanel.add(new JLabel("Computer:"));
            List<CloudComputer> computerList = ((CloudBalance)CloudBalancingPanel.this.getSolution()).getComputerList();
            JComboBox<Object> computerListField = new JComboBox<Object>(computerList.toArray(new Object[computerList.size() + 1]));
            LabeledComboBoxRenderer.applyToComboBox(computerListField);
            computerListField.setSelectedItem(this.process.getComputer());
            listFieldsPanel.add(computerListField);
            int result = JOptionPane.showConfirmDialog(CloudBalancingPanel.this.getRootPane(), listFieldsPanel, "Select computer", 2);
            if (result == 0) {
                CloudComputer toComputer = (CloudComputer)computerListField.getSelectedItem();
                if (this.process.getComputer() != toComputer) {
                    CloudBalancingPanel.this.doProblemChange((workingSolution, problemChangeDirector) -> problemChangeDirector.changeVariable((Object)this.process, "computer", proc -> this.process.setComputer(toComputer)), true);
                    this.removeAction.run();
                }
                CloudBalancingPanel.this.solverAndPersistenceFrame.resetScreen();
            }
        }
    }
}

