/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.business;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.SwingUtilities;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.ScoreManager;
import org.optaplanner.core.api.score.constraint.ConstraintMatchTotal;
import org.optaplanner.core.api.score.constraint.Indictment;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.core.api.solver.SolverJob;
import org.optaplanner.core.api.solver.SolverManager;
import org.optaplanner.core.api.solver.SolverStatus;
import org.optaplanner.core.api.solver.change.ProblemChange;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;
import org.optaplanner.core.impl.solver.DefaultSolverFactory;
import org.optaplanner.core.impl.solver.change.DefaultProblemChangeDirector;
import org.optaplanner.examples.common.app.CommonApp;
import org.optaplanner.examples.common.business.ProblemFileComparator;
import org.optaplanner.examples.common.persistence.AbstractSolutionExporter;
import org.optaplanner.examples.common.persistence.AbstractSolutionImporter;
import org.optaplanner.persistence.common.api.domain.solution.SolutionFileIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolutionBusiness<Solution_, Score_ extends Score<Score_>>
implements AutoCloseable {
    private static final Comparator<File> FILE_COMPARATOR = new ProblemFileComparator();
    private static final AtomicLong SOLVER_JOB_ID_COUNTER = new AtomicLong();
    private static final Logger LOGGER = LoggerFactory.getLogger(SolutionBusiness.class);
    private final CommonApp<Solution_> app;
    private final DefaultSolverFactory<Solution_> solverFactory;
    private final SolverManager<Solution_, Long> solverManager;
    private final ScoreManager<Solution_, Score_> scoreManager;
    private final AtomicReference<SolverJob<Solution_, Long>> solverJobRef = new AtomicReference();
    private final AtomicReference<Solution_> workingSolutionRef = new AtomicReference();
    private File dataDir;
    private SolutionFileIO<Solution_> solutionFileIO;
    private Set<AbstractSolutionImporter<Solution_>> importers;
    private Set<AbstractSolutionExporter<Solution_>> exporters;
    private File importDataDir;
    private File unsolvedDataDir;
    private File solvedDataDir;
    private File exportDataDir;
    private String solutionFileName = null;

    public static String getBaseFileName(File file) {
        return SolutionBusiness.getBaseFileName(file.getName());
    }

    public static String getBaseFileName(String name) {
        int indexOfLastDot = name.lastIndexOf(46);
        if (indexOfLastDot > 0) {
            return name.substring(0, indexOfLastDot);
        }
        return name;
    }

    public SolutionBusiness(CommonApp<Solution_> app, SolverFactory<Solution_> solverFactory) {
        this.app = app;
        this.solverFactory = (DefaultSolverFactory)solverFactory;
        this.solverManager = SolverManager.create(solverFactory);
        this.scoreManager = ScoreManager.create(solverFactory);
    }

    private static List<File> getFileList(File dataDir, String extension) {
        List<File> list;
        block8: {
            Stream<Path> paths = Files.walk(dataDir.toPath(), FileVisitOption.FOLLOW_LINKS);
            try {
                list = paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.toString().endsWith("." + extension)).map(Path::toFile).sorted(FILE_COMPARATOR).collect(Collectors.toList());
                if (paths == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (paths != null) {
                        try {
                            paths.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Error while crawling data directory (" + dataDir + ").", e);
                }
            }
            paths.close();
        }
        return list;
    }

    public String getAppName() {
        return this.app.getName();
    }

    public String getAppDescription() {
        return this.app.getDescription();
    }

    public String getAppIconResource() {
        return this.app.getIconResource();
    }

    public File getDataDir() {
        return this.dataDir;
    }

    public void setDataDir(File dataDir) {
        this.dataDir = dataDir;
    }

    public SolutionFileIO<Solution_> getSolutionFileIO() {
        return this.solutionFileIO;
    }

    public void setSolutionFileIO(SolutionFileIO<Solution_> solutionFileIO) {
        this.solutionFileIO = solutionFileIO;
    }

    public Set<AbstractSolutionImporter<Solution_>> getImporters() {
        return this.importers;
    }

    public void setImporters(Set<AbstractSolutionImporter<Solution_>> importers) {
        this.importers = importers;
    }

    public void addExporter(AbstractSolutionExporter<Solution_> exporter) {
        this.exporters.add(exporter);
    }

    public Set<AbstractSolutionExporter<Solution_>> getExporters() {
        return this.exporters;
    }

    public void setExporters(Set<AbstractSolutionExporter<Solution_>> exporters) {
        if (exporters == null) {
            throw new IllegalArgumentException("Passed exporters must not be null");
        }
        this.exporters = exporters;
    }

    public boolean hasImporter() {
        return !this.importers.isEmpty();
    }

    public boolean hasExporter() {
        return this.exporters != null && this.exporters.size() > 0;
    }

    public void updateDataDirs() {
        if (this.hasImporter()) {
            this.importDataDir = new File(this.dataDir, "import");
            if (!this.importDataDir.exists()) {
                throw new IllegalStateException("The directory importDataDir (" + this.importDataDir.getAbsolutePath() + ") does not exist.");
            }
        }
        this.unsolvedDataDir = new File(this.dataDir, "unsolved");
        if (!this.unsolvedDataDir.exists()) {
            throw new IllegalStateException("The directory unsolvedDataDir (" + this.unsolvedDataDir.getAbsolutePath() + ") does not exist.");
        }
        this.solvedDataDir = new File(this.dataDir, "solved");
        if (!this.solvedDataDir.exists() && !this.solvedDataDir.mkdir()) {
            throw new IllegalStateException("The directory solvedDataDir (" + this.solvedDataDir.getAbsolutePath() + ") does not exist and could not be created.");
        }
        if (this.hasExporter()) {
            this.exportDataDir = new File(this.dataDir, "export");
            if (!this.exportDataDir.exists() && !this.exportDataDir.mkdir()) {
                throw new IllegalStateException("The directory exportDataDir (" + this.exportDataDir.getAbsolutePath() + ") does not exist and could not be created.");
            }
        }
    }

    public File getImportDataDir() {
        return this.importDataDir;
    }

    public File getUnsolvedDataDir() {
        return this.unsolvedDataDir;
    }

    public File getSolvedDataDir() {
        return this.solvedDataDir;
    }

    public File getExportDataDir() {
        return this.exportDataDir;
    }

    public List<File> getUnsolvedFileList() {
        return SolutionBusiness.getFileList(this.unsolvedDataDir, this.solutionFileIO.getInputFileExtension());
    }

    public List<File> getSolvedFileList() {
        return SolutionBusiness.getFileList(this.solvedDataDir, this.solutionFileIO.getOutputFileExtension());
    }

    public Solution_ getSolution() {
        return this.workingSolutionRef.get();
    }

    public void setSolution(Solution_ solution) {
        this.workingSolutionRef.set(solution);
    }

    public String getSolutionFileName() {
        return this.solutionFileName;
    }

    public void setSolutionFileName(String solutionFileName) {
        this.solutionFileName = solutionFileName;
    }

    public Score_ getScore() {
        return (Score_)this.scoreManager.updateScore(this.getSolution());
    }

    public boolean isSolving() {
        SolverJob<Solution_, Long> solverJob = this.solverJobRef.get();
        return solverJob != null && solverJob.getSolverStatus() == SolverStatus.SOLVING_ACTIVE;
    }

    public boolean isConstraintMatchEnabled() {
        return this.applyScoreDirector(InnerScoreDirector::isConstraintMatchEnabled);
    }

    private <Result_> Result_ applyScoreDirector(Function<InnerScoreDirector<Solution_, Score_>, Result_> function) {
        try (InnerScoreDirector scoreDirector = this.solverFactory.getScoreDirectorFactory().buildScoreDirector(true, true);){
            scoreDirector.setWorkingSolution(this.getSolution());
            Result_ result = function.apply(scoreDirector);
            scoreDirector.triggerVariableListeners();
            scoreDirector.calculateScore();
            this.setSolution(scoreDirector.getWorkingSolution());
            Result_ Result_ = result;
            return Result_;
        }
    }

    public List<ConstraintMatchTotal<Score_>> getConstraintMatchTotalList() {
        return this.scoreManager.explainScore(this.getSolution()).getConstraintMatchTotalMap().values().stream().sorted().collect(Collectors.toList());
    }

    public Map<Object, Indictment<Score_>> getIndictmentMap() {
        return this.scoreManager.explainScore(this.getSolution()).getIndictmentMap();
    }

    public void importSolution(File file) {
        AbstractSolutionImporter<Solution_> importer = this.determineImporter(file);
        Solution_ solution = importer.readSolution(file);
        this.solutionFileName = file.getName();
        this.setSolution(solution);
    }

    private AbstractSolutionImporter<Solution_> determineImporter(File file) {
        for (AbstractSolutionImporter<Solution_> importer : this.importers) {
            if (!importer.acceptInputFile(file)) continue;
            return importer;
        }
        return (AbstractSolutionImporter)this.importers.stream().findFirst().orElseThrow();
    }

    public void openSolution(File file) {
        Object solution = this.solutionFileIO.read(file);
        LOGGER.info("Opened: {}", (Object)file);
        this.solutionFileName = file.getName();
        this.workingSolutionRef.set(solution);
    }

    public void saveSolution(File file) {
        this.solutionFileIO.write(this.getSolution(), file);
        LOGGER.info("Saved: {}", (Object)file);
    }

    public void exportSolution(AbstractSolutionExporter<Solution_> exporter, File file) {
        exporter.writeSolution(this.getSolution(), file);
    }

    private void acceptScoreDirector(Consumer<InnerScoreDirector<Solution_, Score_>> consumer) {
        this.applyScoreDirector(s -> {
            consumer.accept((InnerScoreDirector)s);
            return null;
        });
    }

    public void doProblemChange(ProblemChange<Solution_> problemChange) {
        SolverJob<Solution_, Long> solverJob = this.solverJobRef.get();
        if (solverJob != null) {
            solverJob.addProblemChange(problemChange);
        } else {
            this.acceptScoreDirector(scoreDirector -> {
                DefaultProblemChangeDirector problemChangeDirector = new DefaultProblemChangeDirector(scoreDirector);
                problemChangeDirector.doProblemChange(problemChange);
            });
        }
    }

    public Solution_ solve(Solution_ problem, Consumer<Solution_> bestSolutionConsumer) {
        SolverJob solverJob = this.solverManager.solveAndListen((Object)SOLVER_JOB_ID_COUNTER.getAndIncrement(), id -> problem, bestSolution -> {
            this.setSolution(bestSolution);
            SwingUtilities.invokeLater(() -> {
                Solution_ skipToBestSolution = this.getSolution();
                if (bestSolution != skipToBestSolution) {
                    return;
                }
                bestSolutionConsumer.accept(bestSolution);
            });
        });
        this.solverJobRef.set(solverJob);
        try {
            Object object = solverJob.getFinalBestSolution();
            return (Solution_)object;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Solver thread was interrupted.", e);
        }
        catch (ExecutionException e) {
            throw new IllegalStateException("Solver threw an exception.", e);
        }
        finally {
            this.solverJobRef.set(null);
        }
    }

    public void terminateSolvingEarly() {
        SolverJob<Solution_, Long> solverJob = this.solverJobRef.get();
        if (solverJob != null) {
            solverJob.terminateEarly();
        }
    }

    @Override
    public void close() {
        this.terminateSolvingEarly();
        this.solverManager.close();
    }
}

