/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.cloudbalancing.app;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.optaplanner.core.api.solver.change.ProblemChange;
import org.optaplanner.examples.cloudbalancing.domain.CloudBalance;
import org.optaplanner.examples.cloudbalancing.domain.CloudComputer;
import org.optaplanner.examples.cloudbalancing.domain.CloudProcess;
import org.optaplanner.examples.cloudbalancing.persistence.CloudBalancingGenerator;
import org.optaplanner.examples.cloudbalancing.swingui.realtime.AddComputerProblemChange;
import org.optaplanner.examples.cloudbalancing.swingui.realtime.AddProcessProblemChange;
import org.optaplanner.examples.cloudbalancing.swingui.realtime.DeleteComputerProblemChange;
import org.optaplanner.examples.cloudbalancing.swingui.realtime.DeleteProcessProblemChange;
import org.optaplanner.examples.common.app.RealTimePlanningTurtleTest;

class CloudBalancingRealTimePlanningTurtleTest
extends RealTimePlanningTurtleTest<CloudBalance> {
    private CloudBalancingGenerator generator = new CloudBalancingGenerator(true);
    private List<CloudComputer> existingComputerList;
    private List<CloudProcess> existingProcessList;

    CloudBalancingRealTimePlanningTurtleTest() {
    }

    @Override
    protected String createSolverConfigResource() {
        return "org/optaplanner/examples/cloudbalancing/cloudBalancingSolverConfig.xml";
    }

    @Override
    protected CloudBalance readProblem() {
        CloudBalance cloudBalance = this.generator.createCloudBalance(1200, 4800);
        this.existingComputerList = new ArrayList<CloudComputer>(cloudBalance.getComputerList());
        this.existingProcessList = new ArrayList<CloudProcess>(cloudBalance.getProcessList());
        return cloudBalance;
    }

    @Override
    protected ProblemChange<CloudBalance> nextProblemChange(Random random) {
        boolean capacityTooHigh;
        boolean capacityTooLow = this.existingComputerList.size() <= 20 || this.existingComputerList.size() < this.existingProcessList.size() / 4;
        boolean bl = capacityTooHigh = this.existingComputerList.size() > this.existingProcessList.size() / 2;
        if (random.nextBoolean()) {
            if (capacityTooLow || !capacityTooHigh && random.nextBoolean()) {
                CloudComputer computer = this.generator.generateComputerWithoutId();
                this.existingComputerList.add(computer);
                return new AddComputerProblemChange(computer);
            }
            return new DeleteComputerProblemChange(this.existingComputerList.remove(random.nextInt(this.existingComputerList.size())));
        }
        if (capacityTooHigh || !capacityTooLow && random.nextBoolean()) {
            CloudProcess process = this.generator.generateProcessWithoutId();
            this.existingProcessList.add(process);
            return new AddProcessProblemChange(process);
        }
        return new DeleteProcessProblemChange(this.existingProcessList.remove(random.nextInt(this.existingProcessList.size())));
    }
}

