/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.coachshuttlegathering.score;

import java.util.Collections;
import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaplanner.examples.coachshuttlegathering.domain.Bus;
import org.optaplanner.examples.coachshuttlegathering.domain.BusHub;
import org.optaplanner.examples.coachshuttlegathering.domain.BusOrStop;
import org.optaplanner.examples.coachshuttlegathering.domain.BusStop;
import org.optaplanner.examples.coachshuttlegathering.domain.Coach;
import org.optaplanner.examples.coachshuttlegathering.domain.CoachShuttleGatheringSolution;
import org.optaplanner.examples.coachshuttlegathering.domain.Shuttle;
import org.optaplanner.examples.coachshuttlegathering.domain.StopOrHub;
import org.optaplanner.examples.coachshuttlegathering.domain.location.RoadLocation;
import org.optaplanner.examples.coachshuttlegathering.domain.location.RoadLocationArc;
import org.optaplanner.examples.coachshuttlegathering.score.CoachShuttleGatheringConstraintProvider;
import org.optaplanner.examples.common.score.AbstractConstraintProviderTest;
import org.optaplanner.examples.common.score.ConstraintProviderTest;
import org.optaplanner.test.api.score.stream.ConstraintVerifier;

class CoachShuttleGatheringConstraintProviderTest
extends AbstractConstraintProviderTest<CoachShuttleGatheringConstraintProvider, CoachShuttleGatheringSolution> {
    CoachShuttleGatheringConstraintProviderTest() {
    }

    @ConstraintProviderTest
    void coachStopLimit(ConstraintVerifier<CoachShuttleGatheringConstraintProvider, CoachShuttleGatheringSolution> constraintVerifier) {
        Coach coach = new Coach();
        coach.setStopLimit(2);
        BusStop stop1 = new BusStop(0L, (BusOrStop)coach, (Bus)coach);
        BusStop stop2 = new BusStop(1L, (BusOrStop)coach, (Bus)coach);
        BusStop stop3 = new BusStop(2L, (BusOrStop)coach, (Bus)coach);
        BusStop stop4 = new BusStop(3L, (BusOrStop)coach, (Bus)coach);
        constraintVerifier.verifyThat(CoachShuttleGatheringConstraintProvider::coachStopLimit).given(new Object[]{coach, stop1}).penalizesBy(0L);
        constraintVerifier.verifyThat(CoachShuttleGatheringConstraintProvider::coachStopLimit).given(new Object[]{coach, stop1, stop2}).penalizesBy(0L);
        constraintVerifier.verifyThat(CoachShuttleGatheringConstraintProvider::coachStopLimit).given(new Object[]{coach, stop1, stop2, stop3}).penalizesBy(1000000L);
        constraintVerifier.verifyThat(CoachShuttleGatheringConstraintProvider::coachStopLimit).given(new Object[]{coach, stop1, stop2, stop3, stop4}).penalizesBy(2000000L);
    }

    @ConstraintProviderTest
    void shuttleCapacity(ConstraintVerifier<CoachShuttleGatheringConstraintProvider, CoachShuttleGatheringSolution> constraintVerifier) {
        Shuttle shuttle = new Shuttle();
        BusStop destination = new BusStop();
        shuttle.setDestination((StopOrHub)destination);
        shuttle.setCapacity(2);
        shuttle.setPassengerQuantityTotal(Integer.valueOf(1));
        constraintVerifier.verifyThat(CoachShuttleGatheringConstraintProvider::shuttleCapacity).given(new Object[]{shuttle}).penalizesBy(0);
        shuttle.setPassengerQuantityTotal(Integer.valueOf(2));
        constraintVerifier.verifyThat(CoachShuttleGatheringConstraintProvider::shuttleCapacity).given(new Object[]{shuttle}).penalizesBy(0);
        shuttle.setPassengerQuantityTotal(Integer.valueOf(3));
        constraintVerifier.verifyThat(CoachShuttleGatheringConstraintProvider::shuttleCapacity).given(new Object[]{shuttle}).penalizesBy(1000L);
        shuttle.setPassengerQuantityTotal(Integer.valueOf(4));
        constraintVerifier.verifyThat(CoachShuttleGatheringConstraintProvider::shuttleCapacity).given(new Object[]{shuttle}).penalizesBy(2000L);
    }

    @ConstraintProviderTest
    void coachCapacity(ConstraintVerifier<CoachShuttleGatheringConstraintProvider, CoachShuttleGatheringSolution> constraintVerifier) {
        Coach coach = new Coach();
        Shuttle shuttle = new Shuttle();
        BusStop transferStop = new BusStop(0L, (BusOrStop)shuttle, (Bus)coach);
        shuttle.setDestination((StopOrHub)transferStop);
        BusStop shuttlePickup1 = new BusStop(1L, (BusOrStop)transferStop, (Bus)shuttle, 1);
        BusStop shuttlePickup2 = new BusStop(2L, (BusOrStop)transferStop, (Bus)shuttle, 2);
        BusStop shuttlePickup3 = new BusStop(3L, (BusOrStop)transferStop, (Bus)shuttle, 3);
        coach.setCapacity(2);
        coach.setPassengerQuantityTotal(Integer.valueOf(0));
        constraintVerifier.verifyThat(CoachShuttleGatheringConstraintProvider::coachCapacity).given(new Object[]{coach, shuttle, transferStop}).penalizesBy(0L);
        coach.setPassengerQuantityTotal(Integer.valueOf(1));
        constraintVerifier.verifyThat(CoachShuttleGatheringConstraintProvider::coachCapacity).given(new Object[]{coach, shuttle, transferStop, shuttlePickup1}).penalizesBy(0L);
        coach.setPassengerQuantityTotal(Integer.valueOf(1));
        constraintVerifier.verifyThat(CoachShuttleGatheringConstraintProvider::coachCapacity).given(new Object[]{coach, shuttle, transferStop, shuttlePickup1, shuttlePickup2}).penalizesBy(2000L);
        coach.setPassengerQuantityTotal(Integer.valueOf(0));
        constraintVerifier.verifyThat(CoachShuttleGatheringConstraintProvider::coachCapacity).given(new Object[]{coach, shuttle, transferStop, shuttlePickup1, shuttlePickup2}).penalizesBy(1000L);
        coach.setPassengerQuantityTotal(Integer.valueOf(0));
        constraintVerifier.verifyThat(CoachShuttleGatheringConstraintProvider::coachCapacity).given(new Object[]{coach, shuttle, transferStop, shuttlePickup1, shuttlePickup2, shuttlePickup3}).penalizesBy(4000L);
        coach.setPassengerQuantityTotal(Integer.valueOf(3));
        constraintVerifier.verifyThat(CoachShuttleGatheringConstraintProvider::coachCapacity).given(new Object[]{coach, shuttle, transferStop, shuttlePickup1}).penalizesBy(1000L);
    }

    @ConstraintProviderTest
    void coachCapacityShuttleButNoShuttle(ConstraintVerifier<CoachShuttleGatheringConstraintProvider, CoachShuttleGatheringSolution> constraintVerifier) {
        Coach coach = new Coach();
        BusHub destination = new BusHub();
        coach.setDestination(destination);
        coach.setCapacity(2);
        coach.setPassengerQuantityTotal(Integer.valueOf(1));
        constraintVerifier.verifyThat(CoachShuttleGatheringConstraintProvider::coachCapacityShuttleButNoShuttle).given(new Object[]{coach}).penalizesBy(0);
        coach.setPassengerQuantityTotal(Integer.valueOf(2));
        constraintVerifier.verifyThat(CoachShuttleGatheringConstraintProvider::coachCapacityShuttleButNoShuttle).given(new Object[]{coach}).penalizesBy(0);
        coach.setPassengerQuantityTotal(Integer.valueOf(3));
        constraintVerifier.verifyThat(CoachShuttleGatheringConstraintProvider::coachCapacityShuttleButNoShuttle).given(new Object[]{coach}).penalizesBy(1000L);
        coach.setPassengerQuantityTotal(Integer.valueOf(4));
        constraintVerifier.verifyThat(CoachShuttleGatheringConstraintProvider::coachCapacityShuttleButNoShuttle).given(new Object[]{coach}).penalizesBy(2000L);
    }

    @ConstraintProviderTest
    void transportTime(ConstraintVerifier<CoachShuttleGatheringConstraintProvider, CoachShuttleGatheringSolution> constraintVerifier) {
        Coach bus = new Coach();
        BusStop busStop = new BusStop();
        busStop.setPreviousBusOrStop((BusOrStop)bus);
        busStop.setBus((Bus)bus);
        busStop.setPassengerQuantity(0);
        busStop.setTransportTimeLimit(5);
        busStop.setTransportTimeToHub(null);
        constraintVerifier.verifyThat(CoachShuttleGatheringConstraintProvider::transportTime).given(new Object[]{busStop}).penalizesBy(0L);
        busStop.setTransportTimeToHub(Integer.valueOf(10));
        constraintVerifier.verifyThat(CoachShuttleGatheringConstraintProvider::transportTime).given(new Object[]{busStop}).penalizesBy(0L);
        busStop.setPassengerQuantity(1);
        constraintVerifier.verifyThat(CoachShuttleGatheringConstraintProvider::transportTime).given(new Object[]{busStop}).penalizesBy(5L);
    }

    @ConstraintProviderTest
    void shuttleDestinationIsCoachOrHub(ConstraintVerifier<CoachShuttleGatheringConstraintProvider, CoachShuttleGatheringSolution> constraintVerifier) {
        Shuttle shuttle = new Shuttle();
        Coach coach = new Coach();
        BusStop destination = new BusStop();
        shuttle.setDestination((StopOrHub)destination);
        destination.setPreviousBusOrStop((BusOrStop)shuttle);
        destination.setBus((Bus)shuttle);
        constraintVerifier.verifyThat(CoachShuttleGatheringConstraintProvider::shuttleDestinationIsCoachOrHub).given(new Object[]{shuttle, destination}).penalizesBy(1000000000L);
        destination.setBus((Bus)coach);
        constraintVerifier.verifyThat(CoachShuttleGatheringConstraintProvider::shuttleDestinationIsCoachOrHub).given(new Object[]{shuttle, destination}).penalizesBy(0L);
    }

    @ConstraintProviderTest
    void shuttleSetupCost(ConstraintVerifier<CoachShuttleGatheringConstraintProvider, CoachShuttleGatheringSolution> constraintVerifier) {
        Shuttle shuttle = new Shuttle();
        Coach coach = new Coach();
        BusStop destination = new BusStop();
        coach.setNextStop(destination);
        shuttle.setNextStop(destination);
        shuttle.setSetupCost(2);
        constraintVerifier.verifyThat(CoachShuttleGatheringConstraintProvider::shuttleSetupCost).given(new Object[]{shuttle}).penalizesBy(2L);
        shuttle.setSetupCost(3);
        constraintVerifier.verifyThat(CoachShuttleGatheringConstraintProvider::shuttleSetupCost).given(new Object[]{shuttle}).penalizesBy(3L);
        shuttle.setNextStop(null);
        constraintVerifier.verifyThat(CoachShuttleGatheringConstraintProvider::shuttleSetupCost).given(new Object[]{shuttle}).penalizesBy(0L);
        constraintVerifier.verifyThat(CoachShuttleGatheringConstraintProvider::shuttleSetupCost).given(new Object[]{coach}).penalizesBy(0L);
    }

    @ConstraintProviderTest
    void distanceFromPrevious(ConstraintVerifier<CoachShuttleGatheringConstraintProvider, CoachShuttleGatheringSolution> constraintVerifier) {
        Coach bus = new Coach();
        BusStop busStop = new BusStop();
        RoadLocation busLocation = new RoadLocation(0L, 1.0, 0.0);
        RoadLocation busStopLocation = new RoadLocation(0L, 5.0, 0.0);
        RoadLocationArc distance = new RoadLocationArc();
        distance.setCoachDistance(1);
        distance.setCoachDuration(1);
        distance.setShuttleDistance(1);
        distance.setShuttleDuration(1);
        busStopLocation.setTravelDistanceMap(Collections.singletonMap(busLocation, distance));
        busLocation.setTravelDistanceMap(Collections.singletonMap(busStopLocation, distance));
        bus.setDepartureLocation(busLocation);
        busStop.setLocation(busStopLocation);
        bus.setMileageCost(1);
        busStop.setPreviousBusOrStop((BusOrStop)bus);
        busStop.setBus((Bus)bus);
        constraintVerifier.verifyThat(CoachShuttleGatheringConstraintProvider::distanceFromPrevious).given(new Object[]{busStop}).penalizesBy(1L);
    }

    @ConstraintProviderTest
    void distanceBusStopToBusDestination(ConstraintVerifier<CoachShuttleGatheringConstraintProvider, CoachShuttleGatheringSolution> constraintVerifier) {
        Coach bus = new Coach();
        BusStop busStop = new BusStop();
        BusHub busHub = new BusHub();
        RoadLocation busHubLocation = new RoadLocation(0L, 1.0, 0.0);
        RoadLocation busStopLocation = new RoadLocation(0L, 5.0, 0.0);
        RoadLocationArc distance = new RoadLocationArc();
        distance.setCoachDistance(1);
        distance.setCoachDuration(1);
        distance.setShuttleDistance(1);
        distance.setShuttleDuration(1);
        busStopLocation.setTravelDistanceMap(Collections.singletonMap(busHubLocation, distance));
        busHubLocation.setTravelDistanceMap(Collections.singletonMap(busStopLocation, distance));
        busHub.setLocation(busHubLocation);
        bus.setDestination(busHub);
        bus.setNextStop(busStop);
        busStop.setLocation(busStopLocation);
        bus.setMileageCost(1);
        busStop.setPreviousBusOrStop((BusOrStop)bus);
        busStop.setBus((Bus)bus);
        constraintVerifier.verifyThat(CoachShuttleGatheringConstraintProvider::distanceBusStopToBusDestination).given(new Object[]{busStop, bus}).penalizesBy(1L);
    }

    @ConstraintProviderTest
    void distanceCoachDirectlyToDestination(ConstraintVerifier<CoachShuttleGatheringConstraintProvider, CoachShuttleGatheringSolution> constraintVerifier) {
        Coach bus = new Coach();
        BusHub busHub = new BusHub();
        RoadLocation busHubLocation = new RoadLocation(0L, 1.0, 0.0);
        RoadLocation busLocation = new RoadLocation(0L, 5.0, 0.0);
        RoadLocationArc distance = new RoadLocationArc();
        distance.setCoachDistance(1);
        distance.setCoachDuration(1);
        distance.setShuttleDistance(1);
        distance.setShuttleDuration(1);
        busLocation.setTravelDistanceMap(Collections.singletonMap(busHubLocation, distance));
        busHubLocation.setTravelDistanceMap(Collections.singletonMap(busLocation, distance));
        bus.setDepartureLocation(busLocation);
        busHub.setLocation(busHubLocation);
        bus.setDestination(busHub);
        bus.setMileageCost(1);
        constraintVerifier.verifyThat(CoachShuttleGatheringConstraintProvider::distanceCoachDirectlyToDestination).given(new Object[]{bus}).penalizesBy(1L);
    }

    @Override
    protected ConstraintVerifier<CoachShuttleGatheringConstraintProvider, CoachShuttleGatheringSolution> createConstraintVerifier() {
        return ConstraintVerifier.build((ConstraintProvider)new CoachShuttleGatheringConstraintProvider(), CoachShuttleGatheringSolution.class, (Class[])new Class[]{BusOrStop.class, StopOrHub.class, BusStop.class, Shuttle.class, Coach.class});
    }
}

