/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.coachshuttlegathering.swingui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.JPanel;
import org.apache.commons.text.WordUtils;
import org.optaplanner.examples.coachshuttlegathering.domain.Bus;
import org.optaplanner.examples.coachshuttlegathering.domain.BusStop;
import org.optaplanner.examples.coachshuttlegathering.domain.Coach;
import org.optaplanner.examples.coachshuttlegathering.domain.CoachShuttleGatheringSolution;
import org.optaplanner.examples.coachshuttlegathering.domain.StopOrHub;
import org.optaplanner.examples.coachshuttlegathering.domain.location.RoadLocation;
import org.optaplanner.examples.coachshuttlegathering.swingui.CoachShuttleGatheringPanel;
import org.optaplanner.examples.common.swingui.latitudelongitude.LatitudeLongitudeTranslator;
import org.optaplanner.swing.impl.TangoColorFactory;

public class CoachShuttleGatheringWorldPanel
extends JPanel {
    private static final int LOCATION_NAME_TEXT_SIZE = 12;
    private final CoachShuttleGatheringPanel coachShuttleGatheringPanel;
    private BufferedImage canvas = null;
    private LatitudeLongitudeTranslator translator = null;

    public CoachShuttleGatheringWorldPanel(CoachShuttleGatheringPanel coachShuttleGatheringPanel) {
        this.coachShuttleGatheringPanel = coachShuttleGatheringPanel;
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                CoachShuttleGatheringSolution solution = (CoachShuttleGatheringSolution)CoachShuttleGatheringWorldPanel.this.coachShuttleGatheringPanel.getSolution();
                if (solution != null) {
                    CoachShuttleGatheringWorldPanel.this.resetPanel(solution);
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public void resetPanel(CoachShuttleGatheringSolution solution) {
        this.translator = new LatitudeLongitudeTranslator();
        for (RoadLocation location : solution.getLocationList()) {
            this.translator.addCoordinates(location.getLatitude(), location.getLongitude());
        }
        Dimension size = this.getSize();
        double width = size.getWidth();
        double height = size.getHeight();
        this.translator.prepareFor(width, height);
        Graphics2D g = this.createCanvas(width, height);
        g.setColor(TangoColorFactory.ORANGE_3);
        RoadLocation hubLocation = solution.getHub().getLocation();
        this.translator.drawSquare(g, hubLocation.getLongitude(), hubLocation.getLatitude(), 5);
        for (BusStop busStop : solution.getStopList()) {
            RoadLocation location = busStop.getLocation();
            g.setColor(busStop.getPassengerQuantity() <= 0 ? TangoColorFactory.ALUMINIUM_4 : (busStop.getTransportTimeToHub() == null ? TangoColorFactory.ORANGE_2 : (busStop.getTransportTimeRemainder() < 0 ? TangoColorFactory.SCARLET_2 : TangoColorFactory.ORANGE_2)));
            this.translator.drawSquare(g, location.getLongitude(), location.getLatitude(), 3, busStop.getTransportLabel());
        }
        List<Bus> busList = solution.getBusList();
        g.setColor(TangoColorFactory.ALUMINIUM_2);
        g.setFont(g.getFont().deriveFont(12.0f));
        for (Bus bus : busList) {
            RoadLocation location = bus.getLocation();
            g.setColor(bus instanceof Coach ? TangoColorFactory.ORANGE_1 : TangoColorFactory.ALUMINIUM_2);
            this.translator.drawSquare(g, location.getLongitude(), location.getLatitude(), 3, WordUtils.abbreviate((String)bus.getName(), (int)20, (int)-1, (String)"..."));
        }
        boolean bl = false;
        for (Bus bus : busList) {
            void var10_12;
            g.setColor((Color)TangoColorFactory.SEQUENCE_2.get((int)var10_12));
            BusStop lastStop = null;
            for (BusStop stop = bus.getNextStop(); stop != null; stop = stop.getNextStop()) {
                RoadLocation previousLocation = stop.getPreviousBusOrStop().getLocation();
                RoadLocation location = stop.getLocation();
                this.translator.drawRoute(g, previousLocation.getLongitude(), previousLocation.getLatitude(), location.getLongitude(), location.getLatitude(), false, false);
                lastStop = stop;
            }
            if (lastStop != null || bus instanceof Coach) {
                RoadLocation lastStopLocation = lastStop == null ? bus.getLocation() : lastStop.getLocation();
                StopOrHub destination = bus.getDestination();
                if (destination != null) {
                    RoadLocation destinationLocation = destination.getLocation();
                    this.translator.drawRoute(g, lastStopLocation.getLongitude(), lastStopLocation.getLatitude(), destinationLocation.getLongitude(), destinationLocation.getLatitude(), false, true);
                }
            }
            var10_12 = (var10_12 + true) % TangoColorFactory.SEQUENCE_2.size();
        }
        this.repaint();
    }

    public void updatePanel(CoachShuttleGatheringSolution solution) {
        this.resetPanel(solution);
    }

    private Graphics2D createCanvas(double width, double height) {
        int canvasWidth = (int)Math.ceil(width) + 1;
        int canvasHeight = (int)Math.ceil(height) + 1;
        this.canvas = new BufferedImage(canvasWidth, canvasHeight, 1);
        Graphics2D g = this.canvas.createGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, canvasWidth, canvasHeight);
        return g;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.canvas != null) {
            g.drawImage(this.canvas, 0, 0, this);
        }
    }
}

