/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.projectjobscheduling.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.List;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.valuerange.CountableValueRange;
import org.optaplanner.core.api.domain.valuerange.ValueRangeFactory;
import org.optaplanner.core.api.domain.valuerange.ValueRangeProvider;
import org.optaplanner.core.api.domain.variable.PlanningVariable;
import org.optaplanner.core.api.domain.variable.ShadowVariable;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.projectjobscheduling.domain.ExecutionMode;
import org.optaplanner.examples.projectjobscheduling.domain.Job;
import org.optaplanner.examples.projectjobscheduling.domain.JobType;
import org.optaplanner.examples.projectjobscheduling.domain.Project;
import org.optaplanner.examples.projectjobscheduling.domain.solver.DelayStrengthComparator;
import org.optaplanner.examples.projectjobscheduling.domain.solver.ExecutionModeStrengthWeightFactory;
import org.optaplanner.examples.projectjobscheduling.domain.solver.NotSourceOrSinkAllocationFilter;
import org.optaplanner.examples.projectjobscheduling.domain.solver.PredecessorsDoneDateUpdatingVariableListener;

@PlanningEntity(pinningFilter=NotSourceOrSinkAllocationFilter.class)
@XStreamAlias(value="PjsAllocation")
public class Allocation
extends AbstractPersistable {
    private Job job;
    private Allocation sourceAllocation;
    private Allocation sinkAllocation;
    private List<Allocation> predecessorAllocationList;
    private List<Allocation> successorAllocationList;
    private ExecutionMode executionMode;
    private Integer delay;
    private Integer predecessorsDoneDate;

    public Job getJob() {
        return this.job;
    }

    public void setJob(Job job) {
        this.job = job;
    }

    public Allocation getSourceAllocation() {
        return this.sourceAllocation;
    }

    public void setSourceAllocation(Allocation sourceAllocation) {
        this.sourceAllocation = sourceAllocation;
    }

    public Allocation getSinkAllocation() {
        return this.sinkAllocation;
    }

    public void setSinkAllocation(Allocation sinkAllocation) {
        this.sinkAllocation = sinkAllocation;
    }

    public List<Allocation> getPredecessorAllocationList() {
        return this.predecessorAllocationList;
    }

    public void setPredecessorAllocationList(List<Allocation> predecessorAllocationList) {
        this.predecessorAllocationList = predecessorAllocationList;
    }

    public List<Allocation> getSuccessorAllocationList() {
        return this.successorAllocationList;
    }

    public void setSuccessorAllocationList(List<Allocation> successorAllocationList) {
        this.successorAllocationList = successorAllocationList;
    }

    @PlanningVariable(valueRangeProviderRefs={"executionModeRange"}, strengthWeightFactoryClass=ExecutionModeStrengthWeightFactory.class)
    public ExecutionMode getExecutionMode() {
        return this.executionMode;
    }

    public void setExecutionMode(ExecutionMode executionMode) {
        this.executionMode = executionMode;
    }

    @PlanningVariable(valueRangeProviderRefs={"delayRange"}, strengthComparatorClass=DelayStrengthComparator.class)
    public Integer getDelay() {
        return this.delay;
    }

    public void setDelay(Integer delay) {
        this.delay = delay;
    }

    @ShadowVariable.List(value={@ShadowVariable(variableListenerClass=PredecessorsDoneDateUpdatingVariableListener.class, sourceVariableName="executionMode"), @ShadowVariable(variableListenerClass=PredecessorsDoneDateUpdatingVariableListener.class, sourceVariableName="delay")})
    public Integer getPredecessorsDoneDate() {
        return this.predecessorsDoneDate;
    }

    public void setPredecessorsDoneDate(Integer predecessorsDoneDate) {
        this.predecessorsDoneDate = predecessorsDoneDate;
    }

    public Integer getStartDate() {
        if (this.predecessorsDoneDate == null) {
            return null;
        }
        return this.predecessorsDoneDate + (this.delay == null ? 0 : this.delay);
    }

    public Integer getEndDate() {
        if (this.predecessorsDoneDate == null) {
            return null;
        }
        return this.predecessorsDoneDate + (this.delay == null ? 0 : this.delay) + (this.executionMode == null ? 0 : this.executionMode.getDuration());
    }

    public Project getProject() {
        return this.job.getProject();
    }

    public int getProjectCriticalPathEndDate() {
        return this.job.getProject().getCriticalPathEndDate();
    }

    public JobType getJobType() {
        return this.job.getJobType();
    }

    public String getLabel() {
        return "Job " + this.job.getId();
    }

    @ValueRangeProvider(id="executionModeRange")
    public List<ExecutionMode> getExecutionModeRange() {
        return this.job.getExecutionModeList();
    }

    @ValueRangeProvider(id="delayRange")
    public CountableValueRange<Integer> getDelayRange() {
        return ValueRangeFactory.createIntValueRange((int)0, (int)500);
    }
}

