/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.persistence;

import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.TestFactory;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.ScoreManager;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.examples.common.app.CommonApp;
import org.optaplanner.examples.common.app.LoggingTest;
import org.optaplanner.examples.common.business.ProblemFileComparator;
import org.optaplanner.persistence.common.api.domain.solution.SolutionFileIO;

public abstract class OpenDataFilesTest<Solution_>
extends LoggingTest {
    protected abstract CommonApp<Solution_> createCommonApp();

    private static List<File> getSolutionFiles(CommonApp<?> commonApp) {
        ArrayList<File> fileList = new ArrayList<File>(0);
        File dataDir = CommonApp.determineDataDir((String)commonApp.getDataDirName());
        File unsolvedDataDir = new File(dataDir, "unsolved");
        if (!unsolvedDataDir.exists()) {
            throw new IllegalStateException("The directory unsolvedDataDir (" + unsolvedDataDir.getAbsolutePath() + ") does not exist.");
        }
        String inputFileExtension = commonApp.createSolutionFileIO().getInputFileExtension();
        fileList.addAll(FileUtils.listFiles((File)unsolvedDataDir, (String[])new String[]{inputFileExtension}, (boolean)true));
        File solvedDataDir = new File(dataDir, "solved");
        if (solvedDataDir.exists()) {
            String outputFileExtension = commonApp.createSolutionFileIO().getOutputFileExtension();
            fileList.addAll(FileUtils.listFiles((File)solvedDataDir, (String[])new String[]{outputFileExtension}, (boolean)true));
        }
        fileList.sort((Comparator<File>)new ProblemFileComparator());
        return fileList;
    }

    @TestFactory
    @Execution(value=ExecutionMode.CONCURRENT)
    Stream<DynamicTest> readAndWriteSolution() {
        CommonApp<Solution_> commonApp = this.createCommonApp();
        SolverFactory solverFactory = SolverFactory.createFromXmlResource((String)commonApp.getSolverConfigResource());
        ScoreManager scoreManager = ScoreManager.create((SolverFactory)solverFactory);
        return OpenDataFilesTest.getSolutionFiles(commonApp).stream().map(solutionFile -> DynamicTest.dynamicTest((String)solutionFile.getName(), () -> this.readAndWriteSolution((ScoreManager)scoreManager, (SolutionFileIO<Solution_>)commonApp.createSolutionFileIO(), (File)solutionFile)));
    }

    private <Score_ extends Score<Score_>> void readAndWriteSolution(ScoreManager<Solution_, Score_> scoreManager, SolutionFileIO<Solution_> solutionFileIO, File solutionFile) {
        Object originalSolution = solutionFileIO.read(solutionFile);
        this.logger.info("Opened: {}", (Object)solutionFile);
        Score originalScore = scoreManager.updateScore(originalSolution);
        Assertions.assertThat((Comparable)originalScore).isNotNull();
        Object roundTripSolution = null;
        try {
            File tmpFile = File.createTempFile("optaplanner-solution", ".tmp");
            solutionFileIO.write(originalSolution, tmpFile);
            this.logger.info("Written: {}", (Object)tmpFile);
            roundTripSolution = solutionFileIO.read(tmpFile);
            this.logger.info("Re-opened: {}", (Object)tmpFile);
            tmpFile.delete();
        }
        catch (Exception ex) {
            Assertions.fail((String)"Failed to write solution.", (Throwable)ex);
        }
        Score roundTripScore = scoreManager.updateScore(roundTripSolution);
        Assertions.assertThat((Comparable)roundTripScore).isEqualTo((Object)originalScore);
    }
}

