/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.taskassigning.domain.solver;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.optaplanner.examples.taskassigning.domain.Priority;
import org.optaplanner.examples.taskassigning.domain.Skill;
import org.optaplanner.examples.taskassigning.domain.Task;
import org.optaplanner.examples.taskassigning.domain.TaskType;
import org.optaplanner.examples.taskassigning.domain.solver.TaskDifficultyComparator;

class TaskDifficultyComparatorTest {
    TaskDifficultyComparatorTest() {
    }

    @Test
    void compareTasks() {
        Skill skill1 = new Skill(1L, "skill1");
        Skill skill2 = new Skill(2L, "skill2");
        TaskType typeCritical = new TaskType(1L, "Critical", "", 1);
        TaskType typeMajorHard = new TaskType(2L, "Major-Skills2", "", 1);
        TaskType typeMajorMedium = new TaskType(1L, "Major-Skills1", "", 1);
        TaskType typeMajorEasySlow = new TaskType(0L, "Major-Skills0-Slow", "", 999);
        TaskType typeMajorEasyQuick = new TaskType(0L, "Major-Skills0-Quick", "", 100);
        TaskType typeMinor = new TaskType(0L, "Minor", "", 200);
        typeMajorHard.setRequiredSkillList(List.of(skill1, skill2));
        typeMajorMedium.setRequiredSkillList(List.of(skill1));
        Task critical = new Task(0L, typeCritical, 1, null, 0, Priority.CRITICAL);
        Task majorHard = new Task(10L, typeMajorHard, 2, null, 0, Priority.MAJOR);
        Task majorMedium = new Task(11L, typeMajorMedium, 3, null, 0, Priority.MAJOR);
        Task majorEasySlow = new Task(20L, typeMajorEasySlow, 1, null, 0, Priority.MAJOR);
        Task majorEasyQuick = new Task(21L, typeMajorEasyQuick, 2, null, 0, Priority.MAJOR);
        Task minor300 = new Task(300L, typeMinor, 3, null, 0, Priority.MINOR);
        Task minor200 = new Task(200L, typeMinor, 2, null, 0, Priority.MINOR);
        Task minor100 = new Task(100L, typeMinor, 1, null, 0, Priority.MINOR);
        List<Task> decreasingDifficultyList = List.of(critical, majorHard, majorMedium, majorEasySlow, majorEasyQuick, minor300, minor300, minor200, minor100);
        List<Task> input = Arrays.asList(majorEasySlow, minor100, majorMedium, minor300, majorHard, majorEasyQuick, minor200, critical, minor300);
        input.sort(TaskDifficultyComparator.DECREASING_DIFFICULTY_COMPARATOR);
        Assertions.assertThat(input).containsExactlyElementsOf(decreasingDifficultyList);
        Collections.reverse(input);
        Assertions.assertThat(input).isSortedAccordingTo(TaskDifficultyComparator.INCREASING_DIFFICULTY_COMPARATOR);
    }
}

