/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.machinereassignment.persistence;

import java.io.IOException;
import java.util.List;
import org.optaplanner.examples.common.persistence.AbstractTxtSolutionExporter;
import org.optaplanner.examples.common.persistence.SolutionConverter;
import org.optaplanner.examples.machinereassignment.domain.MachineReassignment;
import org.optaplanner.examples.machinereassignment.domain.MrMachine;
import org.optaplanner.examples.machinereassignment.domain.MrProcessAssignment;
import org.optaplanner.examples.machinereassignment.persistence.MachineReassignmentSolutionFileIO;

public class MachineReassignmentExporter
extends AbstractTxtSolutionExporter<MachineReassignment> {
    public static void main(String[] args) {
        SolutionConverter<MachineReassignment> converter = SolutionConverter.createExportConverter("machinereassignment", new MachineReassignmentExporter(), new MachineReassignmentSolutionFileIO());
        converter.convertAll();
    }

    @Override
    public String getOutputFileSuffix() {
        return "txt";
    }

    @Override
    public AbstractTxtSolutionExporter.TxtOutputBuilder<MachineReassignment> createTxtOutputBuilder() {
        return new MachineReassignmentOutputBuilder();
    }

    public static class MachineReassignmentOutputBuilder
    extends AbstractTxtSolutionExporter.TxtOutputBuilder<MachineReassignment> {
        @Override
        public void writeSolution() throws IOException {
            boolean first = true;
            List<MrMachine> machineList = ((MachineReassignment)this.solution).getMachineList();
            for (MrProcessAssignment processAssignment : ((MachineReassignment)this.solution).getProcessAssignmentList()) {
                if (first) {
                    first = false;
                } else {
                    this.bufferedWriter.write(" ");
                }
                this.bufferedWriter.write(Integer.toString(machineList.indexOf(processAssignment.getMachine())));
            }
        }
    }
}

