/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.experimental;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;
import org.optaplanner.core.api.score.stream.uni.UniConstraintCollector;
import org.optaplanner.examples.common.experimental.ExperimentalConstraintCollectors;
import org.optaplanner.examples.common.experimental.api.ConsecutiveInfo;
import org.optaplanner.examples.common.experimental.impl.ConsecutiveIntervalInfoImpl;
import org.optaplanner.examples.common.experimental.impl.ConsecutiveSetTree;
import org.optaplanner.examples.common.experimental.impl.IntervalTree;

class ExperimentalConstraintCollectorsTest {
    ExperimentalConstraintCollectorsTest() {
    }

    @Test
    void consecutive() {
        UniConstraintCollector collector = ExperimentalConstraintCollectors.consecutive(Integer::intValue);
        ConsecutiveSetTree container = (ConsecutiveSetTree)collector.supplier().get();
        int firstValue = 2;
        Runnable firstRetractor = ExperimentalConstraintCollectorsTest.accumulate(collector, container, firstValue);
        ExperimentalConstraintCollectorsTest.assertResult(collector, container, this.consecutiveData(2));
        int secondValue = 1;
        Runnable secondRetractor = ExperimentalConstraintCollectorsTest.accumulate(collector, container, secondValue);
        ExperimentalConstraintCollectorsTest.assertResult(collector, container, this.consecutiveData(1, 2));
        Runnable thirdRetractor = ExperimentalConstraintCollectorsTest.accumulate(collector, container, secondValue);
        ExperimentalConstraintCollectorsTest.assertResult(collector, container, this.consecutiveData(1, 1, 2));
        secondRetractor.run();
        ExperimentalConstraintCollectorsTest.assertResult(collector, container, this.consecutiveData(1, 2));
        thirdRetractor.run();
        ExperimentalConstraintCollectorsTest.assertResult(collector, container, this.consecutiveData(2));
        firstRetractor.run();
        ExperimentalConstraintCollectorsTest.assertResult(collector, container, this.consecutiveData(new Integer[0]));
    }

    @Test
    void consecutiveInterval() {
        UniConstraintCollector collector = ExperimentalConstraintCollectors.consecutiveIntervals(Interval::getStart, Interval::getEnd, (a, b) -> b - a);
        IntervalTree container = (IntervalTree)collector.supplier().get();
        Interval firstValue = new Interval(1, 3);
        Runnable firstRetractor = ExperimentalConstraintCollectorsTest.accumulate(collector, container, firstValue);
        ExperimentalConstraintCollectorsTest.assertResult(collector, container, this.consecutiveIntervalData(firstValue));
        Interval secondValue = new Interval(2, 4);
        Runnable secondRetractor = ExperimentalConstraintCollectorsTest.accumulate(collector, container, secondValue);
        ExperimentalConstraintCollectorsTest.assertResult(collector, container, this.consecutiveIntervalData(firstValue, secondValue));
        Runnable thirdRetractor = ExperimentalConstraintCollectorsTest.accumulate(collector, container, secondValue);
        ExperimentalConstraintCollectorsTest.assertResult(collector, container, this.consecutiveIntervalData(firstValue, secondValue, secondValue));
        secondRetractor.run();
        ExperimentalConstraintCollectorsTest.assertResult(collector, container, this.consecutiveIntervalData(firstValue, secondValue));
        thirdRetractor.run();
        ExperimentalConstraintCollectorsTest.assertResult(collector, container, this.consecutiveIntervalData(firstValue));
        firstRetractor.run();
        ExperimentalConstraintCollectorsTest.assertResult(collector, container, this.consecutiveIntervalData(new Interval[0]));
    }

    private ConsecutiveInfo<Integer, Integer> consecutiveData(Integer ... data) {
        return (ConsecutiveInfo)Arrays.stream(data).collect(() -> new ConsecutiveSetTree((a, b) -> b - a, Integer::sum, (Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(0)), (tree, datum) -> tree.add(datum, (Comparable)datum), ExperimentalConstraintCollectorsTest.mergingNotSupported());
    }

    private ConsecutiveIntervalInfoImpl<Interval, Integer, Integer> consecutiveIntervalData(Interval ... data) {
        return Arrays.stream(data).collect(() -> new IntervalTree(Interval::getStart, Interval::getEnd, (a, b) -> b - a), (tree, datum) -> tree.add(tree.getInterval(datum)), ExperimentalConstraintCollectorsTest.mergingNotSupported()).getConsecutiveIntervalData();
    }

    private static <T> BiConsumer<T, T> mergingNotSupported() {
        return (a, b) -> {
            throw new UnsupportedOperationException();
        };
    }

    private static <A, Container_> Runnable accumulate(UniConstraintCollector<A, Container_, ?> collector, Container_ container, A value) {
        return (Runnable)collector.accumulator().apply(container, value);
    }

    private static <A, Container_, Result_> void assertResult(UniConstraintCollector<A, Container_, Result_> collector, Container_ container, Result_ expectedResult) {
        Object actualResult = collector.finisher().apply(container);
        ((ObjectAssert)Assertions.assertThat(actualResult).as("Collector (" + collector + ") did not produce expected result.", new Object[0])).usingRecursiveComparison().ignoringFields(new String[]{"sourceTree", "indexFunction", "sequenceList", "startItemToSequence"}).isEqualTo(expectedResult);
    }

    private static class Interval {
        final int start;
        final int end;

        public Interval(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Interval interval = (Interval)o;
            return this.start == interval.start && this.end == interval.end;
        }

        public int hashCode() {
            return Objects.hash(this.start, this.end);
        }
    }
}

