/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.curriculumcourse.persistence;

import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import org.optaplanner.examples.common.app.CommonApp;
import org.optaplanner.examples.common.app.LoggingMain;
import org.optaplanner.examples.common.persistence.AbstractSolutionImporter;
import org.optaplanner.examples.common.persistence.generator.StringDataGenerator;
import org.optaplanner.examples.curriculumcourse.domain.Course;
import org.optaplanner.examples.curriculumcourse.domain.CourseSchedule;
import org.optaplanner.examples.curriculumcourse.domain.Curriculum;
import org.optaplanner.examples.curriculumcourse.domain.Day;
import org.optaplanner.examples.curriculumcourse.domain.Lecture;
import org.optaplanner.examples.curriculumcourse.domain.Period;
import org.optaplanner.examples.curriculumcourse.domain.Room;
import org.optaplanner.examples.curriculumcourse.domain.Teacher;
import org.optaplanner.examples.curriculumcourse.domain.Timeslot;
import org.optaplanner.examples.curriculumcourse.domain.UnavailablePeriodPenalty;
import org.optaplanner.persistence.common.api.domain.solution.SolutionFileIO;
import org.optaplanner.persistence.xstream.impl.domain.solution.XStreamSolutionFileIO;

public class CurriculumCourseGenerator
extends LoggingMain {
    private static final int DAY_LIST_SIZE = 5;
    private static final int TIMESLOT_LIST_SIZE = 7;
    private static final int PERIOD_LIST_SIZE = 32;
    private final int[] roomCapacityOptions = new int[]{20, 25, 30, 40, 50};
    private final String[] courseCodes = new String[]{"Math", "Chemistry", "Physics", "Geography", "Biology", "History", "English", "Spanish", "French", "German", "ICT", "Economics", "Psychology", "Art", "Music"};
    private final StringDataGenerator teacherNameGenerator = StringDataGenerator.buildFullNames();
    protected final SolutionFileIO<CourseSchedule> solutionFileIO = new XStreamSolutionFileIO(new Class[]{CourseSchedule.class});
    protected final File outputDir = new File(CommonApp.determineDataDir("curriculumcourse"), "unsolved");
    protected Random random;

    public static void main(String[] args) {
        CurriculumCourseGenerator generator = new CurriculumCourseGenerator();
        generator.writeCourseSchedule(200, 8);
        generator.writeCourseSchedule(400, 16);
        generator.writeCourseSchedule(800, 32);
    }

    private void writeCourseSchedule(int lectureListSize, int curriculumListSize) {
        int courseListSize = lectureListSize * 2 / 9 + 1;
        int teacherListSize = courseListSize / 3 + 1;
        int roomListSize = lectureListSize * 2 / 32;
        String fileName = this.determineFileName(lectureListSize, 32, roomListSize);
        File outputFile = new File(this.outputDir, fileName + ".xml");
        CourseSchedule schedule = this.createCourseSchedule(fileName, teacherListSize, curriculumListSize, courseListSize, lectureListSize, roomListSize);
        this.solutionFileIO.write((Object)schedule, outputFile);
        this.logger.info("Saved: {}", (Object)outputFile);
    }

    private String determineFileName(int lectureListSize, int periodListSize, int roomListSize) {
        return lectureListSize + "lectures-" + periodListSize + "periods-" + roomListSize + "rooms";
    }

    public CourseSchedule createCourseSchedule(String fileName, int teacherListSize, int curriculumListSize, int courseListSize, int lectureListSize, int roomListSize) {
        this.random = new Random(37L);
        CourseSchedule schedule = new CourseSchedule();
        schedule.setId(0L);
        this.createDayList(schedule);
        this.createTimeslotList(schedule);
        this.createPeriodList(schedule);
        this.createTeacherList(schedule, teacherListSize);
        this.createCourseList(schedule, courseListSize);
        this.createLectureList(schedule, lectureListSize);
        this.createRoomList(schedule, roomListSize);
        this.createCurriculumList(schedule, curriculumListSize);
        this.createUnavailablePeriodPenaltyList(schedule);
        int possibleForOneLectureSize = schedule.getPeriodList().size() * schedule.getRoomList().size();
        BigInteger possibleSolutionSize = BigInteger.valueOf(possibleForOneLectureSize).pow(schedule.getLectureList().size());
        this.logger.info("CourseSchedule {} has {} teachers, {} curricula, {} courses, {} lectures, {} periods, {} rooms and {} unavailable period constraints with a search space of {}.", new Object[]{fileName, schedule.getTeacherList().size(), schedule.getCurriculumList().size(), schedule.getCourseList().size(), schedule.getLectureList().size(), schedule.getPeriodList().size(), schedule.getRoomList().size(), schedule.getUnavailablePeriodPenaltyList().size(), AbstractSolutionImporter.getFlooredPossibleSolutionSize(possibleSolutionSize)});
        return schedule;
    }

    private void createDayList(CourseSchedule schedule) {
        ArrayList<Day> dayList = new ArrayList<Day>(5);
        for (int i = 0; i < 5; ++i) {
            Day day = new Day();
            day.setId(Long.valueOf(i));
            day.setDayIndex(i);
            day.setPeriodList(new ArrayList<Period>(7));
            dayList.add(day);
        }
        schedule.setDayList(dayList);
    }

    private void createTimeslotList(CourseSchedule schedule) {
        ArrayList<Timeslot> timeslotList = new ArrayList<Timeslot>(7);
        for (int i = 0; i < 7; ++i) {
            Timeslot timeslot = new Timeslot(i);
            timeslotList.add(timeslot);
        }
        schedule.setTimeslotList(timeslotList);
    }

    private void createPeriodList(CourseSchedule schedule) {
        ArrayList<Period> periodList = new ArrayList<Period>(schedule.getDayList().size() * schedule.getTimeslotList().size());
        long periodId = 0L;
        for (Day day : schedule.getDayList()) {
            for (Timeslot timeslot : schedule.getTimeslotList()) {
                if (day.getDayIndex() == 2 && timeslot.getTimeslotIndex() >= 4) continue;
                Period period = new Period();
                period.setId(periodId);
                ++periodId;
                period.setDay(day);
                day.getPeriodList().add(period);
                period.setTimeslot(timeslot);
                periodList.add(period);
            }
        }
        schedule.setPeriodList(periodList);
    }

    private void createTeacherList(CourseSchedule schedule, int teacherListSize) {
        ArrayList<Teacher> teacherList = new ArrayList<Teacher>(teacherListSize);
        this.teacherNameGenerator.predictMaximumSizeAndReset(teacherListSize);
        for (int i = 0; i < teacherListSize; ++i) {
            Teacher teacher = new Teacher();
            teacher.setId(Long.valueOf(i));
            teacher.setCode(this.teacherNameGenerator.generateNextValue());
            teacherList.add(teacher);
        }
        schedule.setTeacherList(teacherList);
    }

    private void createCourseList(CourseSchedule schedule, int courseListSize) {
        List<Teacher> teacherList = schedule.getTeacherList();
        ArrayList<Course> courseList = new ArrayList<Course>(courseListSize);
        HashSet<String> codeSet = new HashSet<String>();
        for (int i = 0; i < courseListSize; ++i) {
            Course course = new Course();
            course.setId(Long.valueOf(i));
            String code = i < this.courseCodes.length * 2 ? this.courseCodes[i % this.courseCodes.length] : this.courseCodes[this.random.nextInt(this.courseCodes.length)];
            StringDataGenerator codeSuffixGenerator = new StringDataGenerator("").addAToZPart(true, 0);
            if (courseListSize >= this.courseCodes.length) {
                String codeSuffix = codeSuffixGenerator.generateNextValue();
                while (codeSet.contains(code + codeSuffix)) {
                    codeSuffix = codeSuffixGenerator.generateNextValue();
                }
                code = code + codeSuffix;
                codeSet.add(code);
            }
            course.setCode(code);
            Teacher teacher = i < teacherList.size() * 2 ? teacherList.get(i % teacherList.size()) : teacherList.get(this.random.nextInt(teacherList.size()));
            course.setTeacher(teacher);
            course.setLectureSize(0);
            course.setMinWorkingDaySize(1);
            course.setCurriculumSet(new LinkedHashSet<Curriculum>());
            course.setStudentSize(0);
            courseList.add(course);
        }
        schedule.setCourseList(courseList);
    }

    private void createLectureList(CourseSchedule schedule, int lectureListSize) {
        List<Course> courseList = schedule.getCourseList();
        ArrayList<Lecture> lectureList = new ArrayList<Lecture>(lectureListSize);
        for (int i = 0; i < lectureListSize; ++i) {
            Lecture lecture = new Lecture();
            lecture.setId(Long.valueOf(i));
            Course course = i < courseList.size() * 2 ? courseList.get(i % courseList.size()) : courseList.get(this.random.nextInt(courseList.size()));
            lecture.setCourse(course);
            lecture.setLectureIndexInCourse(course.getLectureSize());
            course.setLectureSize(course.getLectureSize() + 1);
            lecture.setPinned(false);
            lectureList.add(lecture);
        }
        schedule.setLectureList(lectureList);
    }

    private void createRoomList(CourseSchedule schedule, int roomListSize) {
        ArrayList<Room> roomList = new ArrayList<Room>(roomListSize);
        for (int i = 0; i < roomListSize; ++i) {
            Room room = new Room();
            room.setId(Long.valueOf(i));
            room.setCode("R" + (i / 50 * 100 + 1 + i));
            room.setCapacity(this.roomCapacityOptions[this.random.nextInt(this.roomCapacityOptions.length)]);
            roomList.add(room);
        }
        schedule.setRoomList(roomList);
    }

    private void createCurriculumList(CourseSchedule schedule, int curriculumListSize) {
        int maximumCapacity = schedule.getRoomList().stream().mapToInt(Room::getCapacity).max().getAsInt();
        List<Course> courseList = schedule.getCourseList();
        ArrayList<Curriculum> curriculumList = new ArrayList<Curriculum>(curriculumListSize);
        StringDataGenerator codeGenerator = new StringDataGenerator("").addAToZPart(true, 0).addAToZPart(false, 1).addAToZPart(false, 1).addAToZPart(false, 1);
        codeGenerator.predictMaximumSizeAndReset(curriculumListSize);
        for (int i = 0; i < curriculumListSize; ++i) {
            Course course2;
            Curriculum curriculum = new Curriculum();
            curriculum.setId(Long.valueOf(i));
            curriculum.setCode("Group " + codeGenerator.generateNextValue());
            int studentSize = 5 + this.random.nextInt(10) + this.random.nextInt(10);
            List courseSubList = courseList.stream().filter(course -> course.getStudentSize() + studentSize < maximumCapacity).collect(Collectors.toList());
            Collections.shuffle(courseSubList, this.random);
            int lectureCount = 0;
            Iterator iterator = courseSubList.iterator();
            while (iterator.hasNext() && (lectureCount += (course2 = (Course)iterator.next()).getLectureSize()) <= 32) {
                course2.getCurriculumSet().add(curriculum);
                course2.setStudentSize(course2.getStudentSize() + studentSize);
            }
            curriculumList.add(curriculum);
        }
        schedule.setCurriculumList(curriculumList);
    }

    private void createUnavailablePeriodPenaltyList(CourseSchedule schedule) {
        List<Course> courseList = schedule.getCourseList();
        List<Period> periodList = schedule.getPeriodList();
        ArrayList<UnavailablePeriodPenalty> unavailablePeriodPenaltyList = new ArrayList<UnavailablePeriodPenalty>(courseList.size());
        long penaltyId = 0L;
        for (Course course : courseList) {
            UnavailablePeriodPenalty penalty = new UnavailablePeriodPenalty();
            penalty.setId(penaltyId);
            ++penaltyId;
            penalty.setCourse(course);
            penalty.setPeriod(periodList.get(this.random.nextInt(periodList.size())));
            unavailablePeriodPenaltyList.add(penalty);
        }
        schedule.setUnavailablePeriodPenaltyList(unavailablePeriodPenaltyList);
    }
}

