/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.meetingscheduling.domain;

import org.apache.commons.lang3.text.WordUtils;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.entity.PlanningPin;
import org.optaplanner.core.api.domain.variable.PlanningVariable;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.meetingscheduling.domain.Meeting;
import org.optaplanner.examples.meetingscheduling.domain.Room;
import org.optaplanner.examples.meetingscheduling.domain.TimeGrain;

@PlanningEntity
public class MeetingAssignment
extends AbstractPersistable {
    private Meeting meeting;
    private boolean pinned;
    private TimeGrain startingTimeGrain;
    private Room room;

    public MeetingAssignment() {
    }

    public MeetingAssignment(long id, Meeting meeting, TimeGrain startingTimeGrain, Room room) {
        super(id);
        this.meeting = meeting;
        this.startingTimeGrain = startingTimeGrain;
        this.room = room;
    }

    public Meeting getMeeting() {
        return this.meeting;
    }

    public void setMeeting(Meeting meeting) {
        this.meeting = meeting;
    }

    @PlanningPin
    public boolean isPinned() {
        return this.pinned;
    }

    public void setPinned(boolean pinned) {
        this.pinned = pinned;
    }

    @PlanningVariable(valueRangeProviderRefs={"timeGrainRange"})
    public TimeGrain getStartingTimeGrain() {
        return this.startingTimeGrain;
    }

    public void setStartingTimeGrain(TimeGrain startingTimeGrain) {
        this.startingTimeGrain = startingTimeGrain;
    }

    @PlanningVariable(valueRangeProviderRefs={"roomRange"})
    public Room getRoom() {
        return this.room;
    }

    public void setRoom(Room room) {
        this.room = room;
    }

    public int calculateOverlap(MeetingAssignment other) {
        if (this.startingTimeGrain == null || other.getStartingTimeGrain() == null) {
            return 0;
        }
        int start = this.startingTimeGrain.getGrainIndex();
        int end = start + this.meeting.getDurationInGrains();
        int otherStart = other.startingTimeGrain.getGrainIndex();
        int otherEnd = otherStart + other.meeting.getDurationInGrains();
        if (end < otherStart) {
            return 0;
        }
        if (otherEnd < start) {
            return 0;
        }
        return Math.min(end, otherEnd) - Math.max(start, otherStart);
    }

    public Integer getLastTimeGrainIndex() {
        if (this.startingTimeGrain == null) {
            return null;
        }
        return this.startingTimeGrain.getGrainIndex() + this.meeting.getDurationInGrains() - 1;
    }

    public String getStartingDateTimeString() {
        if (this.startingTimeGrain == null) {
            return null;
        }
        return this.startingTimeGrain.getDateTimeString();
    }

    public int getRoomCapacity() {
        if (this.room == null) {
            return 0;
        }
        return this.room.getCapacity();
    }

    public int getRequiredCapacity() {
        return this.meeting.getRequiredCapacity();
    }

    public String getLabel() {
        int wrapLength = Math.max(8 * this.meeting.getDurationInGrains(), 16);
        return "<html><center>" + WordUtils.wrap((String)this.meeting.getTopic(), (int)wrapLength, (String)"<br/>", (boolean)false) + "</center></html>";
    }

    @Override
    public String toString() {
        return this.meeting.toString();
    }
}

