/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.nurserostering.optional.score;

import java.util.Comparator;
import java.util.Objects;
import org.optaplanner.examples.nurserostering.domain.Employee;

public class EmployeeWorkSequence
implements Comparable<EmployeeWorkSequence> {
    private static final Comparator<EmployeeWorkSequence> COMPARATOR = Comparator.comparing(EmployeeWorkSequence::getEmployee).thenComparingInt(EmployeeWorkSequence::getFirstDayIndex).thenComparingInt(EmployeeWorkSequence::getLastDayIndex);
    private Employee employee;
    private int firstDayIndex;
    private int lastDayIndex;

    public EmployeeWorkSequence(Employee employee, int firstDayIndex, int lastDayIndex) {
        this.employee = employee;
        this.firstDayIndex = firstDayIndex;
        this.lastDayIndex = lastDayIndex;
    }

    public Employee getEmployee() {
        return this.employee;
    }

    public void setEmployee(Employee employee) {
        this.employee = employee;
    }

    public int getFirstDayIndex() {
        return this.firstDayIndex;
    }

    public void setFirstDayIndex(int firstDayIndex) {
        this.firstDayIndex = firstDayIndex;
    }

    public int getLastDayIndex() {
        return this.lastDayIndex;
    }

    public void setLastDayIndex(int lastDayIndex) {
        this.lastDayIndex = lastDayIndex;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EmployeeWorkSequence other = (EmployeeWorkSequence)o;
        return Objects.equals(this.employee, other.employee) && this.firstDayIndex == other.firstDayIndex && this.lastDayIndex == other.lastDayIndex;
    }

    public int hashCode() {
        return Objects.hash(this.employee, this.firstDayIndex, this.lastDayIndex);
    }

    @Override
    public int compareTo(EmployeeWorkSequence other) {
        return COMPARATOR.compare(this, other);
    }

    public String toString() {
        return this.employee + " is working between " + this.firstDayIndex + " - " + this.lastDayIndex;
    }

    public int getDayLength() {
        return this.lastDayIndex - this.firstDayIndex + 1;
    }
}

