/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.app;

import java.io.File;
import java.util.List;
import org.optaplanner.examples.common.app.CommonApp;
import org.optaplanner.examples.common.app.SolveAllTurtleTest;
import org.optaplanner.persistence.common.api.domain.solution.SolutionFileIO;

public abstract class UnsolvedDirSolveAllTurtleTest<Solution_>
extends SolveAllTurtleTest<Solution_> {
    private static <Solution_> List<File> getUnsolvedDirFiles(CommonApp<Solution_> commonApp) {
        File dataDir = CommonApp.determineDataDir((String)commonApp.getDataDirName());
        File unsolvedDataDir = new File(dataDir, "unsolved");
        if (!unsolvedDataDir.exists()) {
            throw new IllegalStateException("The directory unsolvedDataDir (" + unsolvedDataDir.getAbsolutePath() + ") does not exist.");
        }
        String inputFileExtension = commonApp.createSolutionFileIO().getInputFileExtension();
        return UnsolvedDirSolveAllTurtleTest.getAllFilesRecursivelyAndSorted(unsolvedDataDir, file -> file.getName().endsWith(inputFileExtension));
    }

    @Override
    protected List<File> getSolutionFiles(CommonApp<Solution_> commonApp) {
        return UnsolvedDirSolveAllTurtleTest.getUnsolvedDirFiles(commonApp);
    }

    @Override
    protected SolveAllTurtleTest.ProblemFactory<Solution_> createProblemFactory(CommonApp<Solution_> commonApp) {
        SolutionFileIO solutionFileIO = commonApp.createSolutionFileIO();
        return dataFile -> {
            Object problem = solutionFileIO.read(dataFile);
            this.logger.info("Opened: {}", dataFile);
            return problem;
        };
    }
}

