/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.curriculumcourse.domain;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import java.util.Objects;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.common.swingui.components.Labeled;
import org.optaplanner.examples.curriculumcourse.domain.Day;
import org.optaplanner.examples.curriculumcourse.domain.Timeslot;

@JsonIdentityInfo(scope=Period.class, generator=ObjectIdGenerators.PropertyGenerator.class, property="id")
public class Period
extends AbstractPersistable
implements Labeled {
    private Day day;
    private Timeslot timeslot;

    public Period() {
    }

    public Period(long id, Day day, Timeslot timeslot) {
        super(id);
        this.day = Objects.requireNonNull(day);
        day.getPeriodList().add(this);
        this.timeslot = Objects.requireNonNull(timeslot);
    }

    public Day getDay() {
        return this.day;
    }

    public void setDay(Day day) {
        this.day = day;
    }

    public Timeslot getTimeslot() {
        return this.timeslot;
    }

    public void setTimeslot(Timeslot timeslot) {
        this.timeslot = timeslot;
    }

    @Override
    @JsonIgnore
    public String getLabel() {
        return this.day.getLabel() + " " + this.timeslot.getLabel();
    }

    @Override
    public String toString() {
        return this.day + "-" + this.timeslot;
    }
}

