/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.pas.domain;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import java.util.List;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.common.swingui.components.Labeled;
import org.optaplanner.examples.pas.domain.AdmissionPart;
import org.optaplanner.examples.pas.domain.Patient;
import org.optaplanner.examples.pas.domain.Room;

@JsonIdentityInfo(scope=Department.class, generator=ObjectIdGenerators.PropertyGenerator.class, property="id")
public class Department
extends AbstractPersistable
implements Labeled {
    private String name;
    private Integer minimumAge = null;
    private Integer maximumAge = null;
    private List<Room> roomList;

    public Department() {
    }

    public Department(long id, String name) {
        super(id);
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getMinimumAge() {
        return this.minimumAge;
    }

    public void setMinimumAge(Integer minimumAge) {
        this.minimumAge = minimumAge;
    }

    public Integer getMaximumAge() {
        return this.maximumAge;
    }

    public void setMaximumAge(Integer maximumAge) {
        this.maximumAge = maximumAge;
    }

    public List<Room> getRoomList() {
        return this.roomList;
    }

    public void setRoomList(List<Room> roomList) {
        this.roomList = roomList;
    }

    public int countHardDisallowedAdmissionPart(AdmissionPart admissionPart) {
        return this.countDisallowedPatientAge(admissionPart.getPatient());
    }

    public int countDisallowedPatientAge(Patient patient) {
        int count = 0;
        if (this.minimumAge != null && patient.getAge() < this.minimumAge) {
            count += 100;
        }
        if (this.maximumAge != null && patient.getAge() > this.maximumAge) {
            count += 100;
        }
        return count;
    }

    @Override
    public String getLabel() {
        Object label = this.name;
        if (this.minimumAge != null) {
            label = (String)label + "(\u2265" + this.minimumAge + ")";
        }
        if (this.maximumAge != null) {
            label = (String)label + "(\u2264" + this.maximumAge + ")";
        }
        return label;
    }

    @Override
    public String toString() {
        return this.name;
    }
}

