/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.vehiclerouting.score;

import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.hardsoftlong.HardSoftLongScore;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.ConstraintCollectors;
import org.optaplanner.core.api.score.stream.ConstraintFactory;
import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaplanner.examples.vehiclerouting.domain.Customer;
import org.optaplanner.examples.vehiclerouting.domain.timewindowed.TimeWindowedCustomer;

public class VehicleRoutingConstraintProvider
implements ConstraintProvider {
    public Constraint[] defineConstraints(ConstraintFactory factory) {
        return new Constraint[]{this.vehicleCapacity(factory), this.distanceToPreviousStandstill(factory), this.distanceFromLastCustomerToDepot(factory), this.arrivalAfterDueTime(factory)};
    }

    protected Constraint vehicleCapacity(ConstraintFactory factory) {
        return factory.forEach(Customer.class).filter(customer -> customer.getVehicle() != null).groupBy(Customer::getVehicle, ConstraintCollectors.sum(Customer::getDemand)).filter((vehicle, demand) -> demand > vehicle.getCapacity()).penalizeLong((Score)HardSoftLongScore.ONE_HARD, (vehicle, demand) -> demand - vehicle.getCapacity()).asConstraint("vehicleCapacity");
    }

    protected Constraint distanceToPreviousStandstill(ConstraintFactory factory) {
        return factory.forEach(Customer.class).filter(customer -> customer.getVehicle() != null).penalizeLong((Score)HardSoftLongScore.ONE_SOFT, Customer::getDistanceFromPreviousStandstill).asConstraint("distanceToPreviousStandstill");
    }

    protected Constraint distanceFromLastCustomerToDepot(ConstraintFactory factory) {
        return factory.forEach(Customer.class).filter(customer -> customer.getVehicle() != null && customer.getNextCustomer() == null).penalizeLong((Score)HardSoftLongScore.ONE_SOFT, Customer::getDistanceToDepot).asConstraint("distanceFromLastCustomerToDepot");
    }

    protected Constraint arrivalAfterDueTime(ConstraintFactory factory) {
        return factory.forEach(TimeWindowedCustomer.class).filter(customer -> customer.getVehicle() != null && customer.getArrivalTime() > customer.getDueTime()).penalizeLong((Score)HardSoftLongScore.ONE_HARD, customer -> customer.getArrivalTime() - customer.getDueTime()).asConstraint("arrivalAfterDueTime");
    }
}

