/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.app;

import java.io.File;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.TestFactory;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.ScoreExplanation;
import org.optaplanner.core.api.score.constraint.ConstraintMatchTotal;
import org.optaplanner.core.api.score.stream.ConstraintStreamImplType;
import org.optaplanner.core.api.solver.SolutionManager;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.core.config.score.director.ScoreDirectorFactoryConfig;
import org.optaplanner.core.config.solver.EnvironmentMode;
import org.optaplanner.core.config.solver.SolverConfig;
import org.optaplanner.core.config.solver.termination.TerminationConfig;
import org.optaplanner.core.impl.testutil.DisabledInProductization;
import org.optaplanner.examples.common.app.CommonApp;
import org.optaplanner.examples.common.app.LoggingTest;
import org.optaplanner.persistence.common.api.domain.solution.SolutionFileIO;

public abstract class SolverSmokeTest<Solution_, Score_ extends Score<Score_>>
extends LoggingTest {
    private static final String MOVE_THREAD_COUNTS_STRING = System.getProperty("moveThreadCounts");
    protected SolutionFileIO<Solution_> solutionFileIO;
    protected String solverConfigResource;

    private static Stream<String> moveThreadCounts() {
        return Optional.ofNullable(MOVE_THREAD_COUNTS_STRING).map(s -> Arrays.stream(s.split(","))).orElse(Stream.of("NONE"));
    }

    @BeforeEach
    public void setUp() {
        CommonApp<Solution_> commonApp = this.createCommonApp();
        this.solutionFileIO = commonApp.createSolutionFileIO();
        this.solverConfigResource = commonApp.getSolverConfigResource();
    }

    @TestFactory
    @Execution(value=ExecutionMode.CONCURRENT)
    @Timeout(value=600L)
    Stream<DynamicTest> runSpeedTest() {
        return this.runSpeedTest(ConstraintStreamImplType.DROOLS);
    }

    @DisabledInProductization
    @TestFactory
    @Execution(value=ExecutionMode.CONCURRENT)
    @Timeout(value=600L)
    Stream<DynamicTest> runSpeedTestBavet() {
        return this.runSpeedTest(ConstraintStreamImplType.BAVET);
    }

    private Stream<DynamicTest> runSpeedTest(ConstraintStreamImplType constraintStreamImplType) {
        return SolverSmokeTest.moveThreadCounts().flatMap(moveThreadCount -> this.testData().filter(testData -> testData.constraintStreamImplType == constraintStreamImplType).flatMap(testData -> {
            Stream.Builder<DynamicTest> streamBuilder = Stream.builder();
            streamBuilder.add(this.createSpeedTest(testData.constraintStreamImplType, testData.unsolvedDataFile, EnvironmentMode.REPRODUCIBLE, testData.bestScoreLimitForReproducible, (String)moveThreadCount));
            if (testData.bestScoreLimitForFastAssert != null) {
                streamBuilder.add(this.createSpeedTest(testData.constraintStreamImplType, testData.unsolvedDataFile, EnvironmentMode.FAST_ASSERT, testData.bestScoreLimitForFastAssert, (String)moveThreadCount));
            }
            if (testData.bestScoreLimitForFullAssert != null) {
                streamBuilder.add(this.createSpeedTest(testData.constraintStreamImplType, testData.unsolvedDataFile, EnvironmentMode.FULL_ASSERT, testData.bestScoreLimitForFullAssert, (String)moveThreadCount));
            }
            return streamBuilder.build();
        }));
    }

    private DynamicTest createSpeedTest(ConstraintStreamImplType constraintStreamImplType, String unsolvedDataFile, EnvironmentMode environmentMode, Score_ bestScoreLimit, String moveThreadCount) {
        String testName = constraintStreamImplType + ", " + unsolvedDataFile.replaceFirst(".*/", "") + ", " + environmentMode + ", threads: " + moveThreadCount;
        return DynamicTest.dynamicTest((String)testName, () -> this.runSpeedTest(constraintStreamImplType, new File(unsolvedDataFile), bestScoreLimit, environmentMode, moveThreadCount));
    }

    @TestFactory
    @Execution(value=ExecutionMode.CONCURRENT)
    @Timeout(value=600L)
    @DisabledInProductization
    Stream<DynamicTest> runConstraintStreamsMutualCorrectnessTest() {
        SolverFactory<Solution_> solverFactory = this.buildMutualCorrectnessSolverFactory();
        return this.testData().map(testData -> new File(testData.unsolvedDataFile)).distinct().map(inputSolutionFile -> this.createConstraintStreamsMutualCorrectnessTest(solverFactory, (File)inputSolutionFile));
    }

    private DynamicTest createConstraintStreamsMutualCorrectnessTest(SolverFactory<Solution_> solverFactory, File unsolvedDataFile) {
        String testName = "DROOLS v. BAVET, " + unsolvedDataFile.toString().replaceFirst(".*/", "") + ", " + EnvironmentMode.FULL_ASSERT;
        return DynamicTest.dynamicTest((String)testName, () -> this.runConstraintStreamsMutualCorrectnessTest(solverFactory, unsolvedDataFile));
    }

    protected abstract CommonApp<Solution_> createCommonApp();

    protected abstract Stream<TestData<Score_>> testData();

    private void runSpeedTest(ConstraintStreamImplType constraintStreamImplType, File unsolvedDataFile, Score_ bestScoreLimit, EnvironmentMode environmentMode, String moveThreadCount) {
        SolverFactory<Solution_> solverFactory = this.buildSpeedSolverFactory(constraintStreamImplType, bestScoreLimit, environmentMode, moveThreadCount);
        Object problem = this.solutionFileIO.read(unsolvedDataFile);
        this.logger.info("Opened: {}", (Object)unsolvedDataFile);
        Solver solver = solverFactory.buildSolver();
        Object bestSolution = solver.solve(problem);
        this.assertScoreAndConstraintMatches(solverFactory, bestSolution, bestScoreLimit);
    }

    private SolverFactory<Solution_> buildSpeedSolverFactory(ConstraintStreamImplType constraintStreamImplType, Score_ bestScoreLimit, EnvironmentMode environmentMode, String moveThreadCount) {
        SolverConfig solverConfig = SolverConfig.createFromXmlResource((String)this.solverConfigResource);
        solverConfig.withEnvironmentMode(environmentMode).withTerminationConfig(new TerminationConfig().withBestScoreLimit(bestScoreLimit.toString())).withMoveThreadCount(moveThreadCount);
        ScoreDirectorFactoryConfig scoreDirectorFactoryConfig = Objects.requireNonNullElseGet(solverConfig.getScoreDirectorFactoryConfig(), ScoreDirectorFactoryConfig::new);
        if (scoreDirectorFactoryConfig.getConstraintProviderClass() == null) {
            Assertions.fail((String)"Test does not support constraint streams.");
        }
        scoreDirectorFactoryConfig.setConstraintStreamImplType(constraintStreamImplType);
        solverConfig.setScoreDirectorFactoryConfig(scoreDirectorFactoryConfig);
        return SolverFactory.create((SolverConfig)solverConfig);
    }

    private void runConstraintStreamsMutualCorrectnessTest(SolverFactory<Solution_> solverFactory, File unsolvedDataFile) {
        Object problem = this.solutionFileIO.read(unsolvedDataFile);
        this.logger.info("Opened: {}", (Object)unsolvedDataFile);
        Solver solver = solverFactory.buildSolver();
        Assertions.assertThatNoException().isThrownBy(() -> solver.solve(problem));
    }

    private SolverFactory<Solution_> buildMutualCorrectnessSolverFactory() {
        SolverConfig solverConfig = SolverConfig.createFromXmlResource((String)this.solverConfigResource);
        solverConfig.withEnvironmentMode(EnvironmentMode.FULL_ASSERT).withTerminationConfig(new TerminationConfig().withSecondsSpentLimit(Long.valueOf(10L)));
        ScoreDirectorFactoryConfig scoreDirectorFactoryConfig = Objects.requireNonNullElseGet(solverConfig.getScoreDirectorFactoryConfig(), ScoreDirectorFactoryConfig::new);
        if (scoreDirectorFactoryConfig.getConstraintProviderClass() == null) {
            Assertions.fail((String)"Test does not support constraint streams.");
        }
        scoreDirectorFactoryConfig.setConstraintStreamImplType(ConstraintStreamImplType.DROOLS);
        ScoreDirectorFactoryConfig assertionScoreDirectorFactoryConfig = new ScoreDirectorFactoryConfig();
        assertionScoreDirectorFactoryConfig.setConstraintProviderClass(scoreDirectorFactoryConfig.getConstraintProviderClass());
        assertionScoreDirectorFactoryConfig.setConstraintStreamImplType(ConstraintStreamImplType.BAVET);
        scoreDirectorFactoryConfig.setAssertionScoreDirectorFactory(assertionScoreDirectorFactoryConfig);
        solverConfig.setScoreDirectorFactoryConfig(scoreDirectorFactoryConfig);
        return SolverFactory.create((SolverConfig)solverConfig);
    }

    private void assertScoreAndConstraintMatches(SolverFactory<Solution_> solverFactory, Solution_ bestSolution, Score_ bestScoreLimit) {
        Assertions.assertThat(bestSolution).isNotNull();
        SolutionManager solutionManager = SolutionManager.create(solverFactory);
        Score bestScore = solutionManager.update(bestSolution);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)bestScore).as("The bestScore (" + bestScore + ") must be at least the bestScoreLimit (" + bestScoreLimit + ").", new Object[0])).isGreaterThanOrEqualTo(bestScoreLimit);
        ScoreExplanation scoreExplanation = solutionManager.explain(bestSolution);
        Map constraintMatchTotals = scoreExplanation.getConstraintMatchTotalMap();
        Assertions.assertThat((Map)constraintMatchTotals).isNotNull();
        Assertions.assertThat((Comparable)constraintMatchTotals.values().stream().map(ConstraintMatchTotal::getScore).reduce(Score::add).orElse(bestScore.zero())).isEqualTo((Object)scoreExplanation.getScore());
        Assertions.assertThat((Map)scoreExplanation.getIndictmentMap()).isNotNull();
    }

    protected static class TestData<Score_ extends Score<Score_>> {
        private final ConstraintStreamImplType constraintStreamImplType;
        private final String unsolvedDataFile;
        private final Score_ bestScoreLimitForReproducible;
        private final Score_ bestScoreLimitForFastAssert;
        private final Score_ bestScoreLimitForFullAssert;

        public static <Score_ extends Score<Score_>> TestData<Score_> of(ConstraintStreamImplType constraintStreamImplType, String unsolvedDataFile, Score_ bestScoreLimitForReproducible) {
            return TestData.of(constraintStreamImplType, unsolvedDataFile, bestScoreLimitForReproducible, null);
        }

        public static <Score_ extends Score<Score_>> TestData<Score_> of(ConstraintStreamImplType constraintStreamImplType, String unsolvedDataFile, Score_ bestScoreLimitForReproducible, Score_ bestScoreLimitForFastAssert) {
            return TestData.of(constraintStreamImplType, unsolvedDataFile, bestScoreLimitForReproducible, bestScoreLimitForFastAssert, null);
        }

        public static <Score_ extends Score<Score_>> TestData<Score_> of(ConstraintStreamImplType constraintStreamImplType, String unsolvedDataFile, Score_ bestScoreLimitForReproducible, Score_ bestScoreLimitForFastAssert, Score_ bestScoreLimitForFullAssert) {
            return new TestData<Score_>(constraintStreamImplType, unsolvedDataFile, bestScoreLimitForReproducible, bestScoreLimitForFastAssert, bestScoreLimitForFullAssert);
        }

        private TestData(ConstraintStreamImplType constraintStreamImplType, String unsolvedDataFile, Score_ bestScoreLimitForReproducible, Score_ bestScoreLimitForFastAssert, Score_ bestScoreLimitForFullAssert) {
            this.constraintStreamImplType = constraintStreamImplType;
            this.unsolvedDataFile = unsolvedDataFile;
            this.bestScoreLimitForReproducible = (Score)Objects.requireNonNull(bestScoreLimitForReproducible);
            this.bestScoreLimitForFastAssert = bestScoreLimitForFastAssert;
            this.bestScoreLimitForFullAssert = bestScoreLimitForFullAssert;
        }
    }
}

