/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.persistence.jackson;

import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.KeyDeserializer;
import java.util.Objects;
import org.optaplanner.examples.common.domain.AbstractPersistable;

public abstract class AbstractKeyDeserializer<E extends AbstractPersistable>
extends KeyDeserializer {
    private final Class<E> persistableClass;

    protected AbstractKeyDeserializer(Class<E> persistableClass) {
        this.persistableClass = Objects.requireNonNull(persistableClass);
    }

    public final E deserializeKey(String value, DeserializationContext deserializationContext) {
        String[] parts = value.split("#");
        String className = parts[0];
        if (!Objects.equals(className, this.persistableClass.getSimpleName())) {
            throw new IllegalStateException("Impossible state: not the correct type (" + value + ").");
        }
        String idString = parts[1];
        try {
            long id = Long.parseLong(idString);
            return this.createInstance(id);
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException("Impossible state: id is not a number (" + idString + ")");
        }
    }

    protected abstract E createInstance(long var1);
}

