/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.pas.persistence;

import java.io.IOException;
import java.util.Comparator;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.common.persistence.AbstractTxtSolutionExporter;
import org.optaplanner.examples.common.persistence.SolutionConverter;
import org.optaplanner.examples.pas.domain.BedDesignation;
import org.optaplanner.examples.pas.domain.Patient;
import org.optaplanner.examples.pas.domain.PatientAdmissionSchedule;
import org.optaplanner.examples.pas.persistence.PatientAdmissionScheduleSolutionFileIO;

public class PatientAdmissionScheduleExporter
extends AbstractTxtSolutionExporter<PatientAdmissionSchedule> {
    public static void main(String[] args) {
        SolutionConverter<PatientAdmissionSchedule> converter = SolutionConverter.createExportConverter("pas", new PatientAdmissionScheduleExporter(), new PatientAdmissionScheduleSolutionFileIO());
        converter.convertAll();
    }

    @Override
    public AbstractTxtSolutionExporter.TxtOutputBuilder<PatientAdmissionSchedule> createTxtOutputBuilder() {
        return new PatientAdmissionScheduleOutputBuilder();
    }

    public static class PatientAdmissionScheduleOutputBuilder
    extends AbstractTxtSolutionExporter.TxtOutputBuilder<PatientAdmissionSchedule> {
        private static final Comparator<BedDesignation> COMPARATOR = Comparator.comparing(BedDesignation::getAdmissionPart, Comparator.comparingLong(AbstractPersistable::getId)).thenComparing(BedDesignation::getBed, Comparator.comparingLong(AbstractPersistable::getId)).thenComparingLong(AbstractPersistable::getId);

        @Override
        public void writeSolution() throws IOException {
            ((PatientAdmissionSchedule)this.solution).getBedDesignationList().sort(COMPARATOR);
            for (Patient patient : ((PatientAdmissionSchedule)this.solution).getPatientList()) {
                this.bufferedWriter.write(Long.toString(patient.getId()));
                for (BedDesignation bedDesignation : ((PatientAdmissionSchedule)this.solution).getBedDesignationList()) {
                    if (!bedDesignation.getPatient().equals(patient)) continue;
                    for (int i = 0; i < bedDesignation.getAdmissionPart().getNightCount(); ++i) {
                        this.bufferedWriter.write(" " + bedDesignation.getBed().getId());
                    }
                }
                this.bufferedWriter.write("\n");
            }
        }
    }
}

