/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.projectjobscheduling.domain.solver;

import java.util.Comparator;
import java.util.HashMap;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionSorterWeightFactory;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.projectjobscheduling.domain.ExecutionMode;
import org.optaplanner.examples.projectjobscheduling.domain.ResourceRequirement;
import org.optaplanner.examples.projectjobscheduling.domain.Schedule;
import org.optaplanner.examples.projectjobscheduling.domain.resource.Resource;

public class ExecutionModeStrengthWeightFactory
implements SelectionSorterWeightFactory<Schedule, ExecutionMode> {
    public ExecutionModeStrengthWeight createSorterWeight(Schedule schedule, ExecutionMode executionMode) {
        HashMap<Resource, Integer> requirementTotalMap = new HashMap<Resource, Integer>(executionMode.getResourceRequirementList().size());
        for (ResourceRequirement resourceRequirement : executionMode.getResourceRequirementList()) {
            requirementTotalMap.put(resourceRequirement.getResource(), 0);
        }
        for (ResourceRequirement resourceRequirement : schedule.getResourceRequirementList()) {
            Resource resource = resourceRequirement.getResource();
            Integer total = (Integer)requirementTotalMap.get(resource);
            if (total == null) continue;
            total = total + resourceRequirement.getRequirement();
            requirementTotalMap.put(resource, total);
        }
        double requirementDesirability = 0.0;
        for (ResourceRequirement resourceRequirement : executionMode.getResourceRequirementList()) {
            Resource resource = resourceRequirement.getResource();
            int total = (Integer)requirementTotalMap.get(resource);
            if (total <= resource.getCapacity()) continue;
            requirementDesirability += (double)(total - resource.getCapacity()) * (double)resourceRequirement.getRequirement() * (resource.isRenewable() ? 1.0 : 100.0);
        }
        return new ExecutionModeStrengthWeight(executionMode, requirementDesirability);
    }

    public static class ExecutionModeStrengthWeight
    implements Comparable<ExecutionModeStrengthWeight> {
        private static final Comparator<ExecutionModeStrengthWeight> COMPARATOR = Comparator.comparingDouble(weight -> weight.requirementDesirability).thenComparing(weight -> weight.executionMode, Comparator.comparingLong(AbstractPersistable::getId));
        private final ExecutionMode executionMode;
        private final double requirementDesirability;

        public ExecutionModeStrengthWeight(ExecutionMode executionMode, double requirementDesirability) {
            this.executionMode = executionMode;
            this.requirementDesirability = requirementDesirability;
        }

        @Override
        public int compareTo(ExecutionModeStrengthWeight other) {
            return COMPARATOR.compare(this, other);
        }
    }
}

