/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.coachshuttlegathering.domain.solver;

import org.optaplanner.core.api.domain.variable.VariableListener;
import org.optaplanner.core.api.score.director.ScoreDirector;
import org.optaplanner.examples.coachshuttlegathering.domain.Bus;
import org.optaplanner.examples.coachshuttlegathering.domain.BusStop;
import org.optaplanner.examples.coachshuttlegathering.domain.CoachShuttleGatheringSolution;

public abstract class BusPassengerCountTotalUpdatingVariableListener
implements VariableListener<CoachShuttleGatheringSolution, Object> {
    public void beforeEntityAdded(ScoreDirector<CoachShuttleGatheringSolution> scoreDirector, Object busStop) {
    }

    public void afterEntityAdded(ScoreDirector<CoachShuttleGatheringSolution> scoreDirector, Object entity) {
        if (entity instanceof BusStop) {
            this.updateBusPassengerCount(scoreDirector, (BusStop)entity, true);
        }
    }

    public void beforeVariableChanged(ScoreDirector<CoachShuttleGatheringSolution> scoreDirector, Object entity) {
        if (entity instanceof BusStop) {
            this.updateBusPassengerCount(scoreDirector, (BusStop)entity, false);
        }
    }

    public void afterVariableChanged(ScoreDirector<CoachShuttleGatheringSolution> scoreDirector, Object entity) {
        if (entity instanceof BusStop) {
            this.updateBusPassengerCount(scoreDirector, (BusStop)entity, true);
        }
    }

    public void beforeEntityRemoved(ScoreDirector<CoachShuttleGatheringSolution> scoreDirector, Object entity) {
    }

    public void afterEntityRemoved(ScoreDirector<CoachShuttleGatheringSolution> scoreDirector, Object entity) {
        if (entity instanceof BusStop) {
            this.updateBusPassengerCount(scoreDirector, (BusStop)entity, false);
        }
    }

    private void updateBusPassengerCount(ScoreDirector<CoachShuttleGatheringSolution> scoreDirector, BusStop busStop, boolean increase) {
        Bus bus = busStop.getBus();
        if (!this.isCorrectBusInstance(bus)) {
            return;
        }
        int difference = increase ? busStop.getPassengerQuantity() : -busStop.getPassengerQuantity();
        scoreDirector.beforeVariableChanged((Object)bus, "passengerQuantityTotal");
        bus.setPassengerQuantityTotal(bus.getPassengerQuantityTotal() + difference);
        scoreDirector.afterVariableChanged((Object)bus, "passengerQuantityTotal");
    }

    protected abstract boolean isCorrectBusInstance(Bus var1);
}

