/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.nqueens.app;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.core.config.constructionheuristic.ConstructionHeuristicPhaseConfig;
import org.optaplanner.core.config.constructionheuristic.ConstructionHeuristicType;
import org.optaplanner.core.config.heuristic.selector.common.SelectionOrder;
import org.optaplanner.core.config.heuristic.selector.move.MoveSelectorConfig;
import org.optaplanner.core.config.heuristic.selector.move.generic.ChangeMoveSelectorConfig;
import org.optaplanner.core.config.localsearch.LocalSearchPhaseConfig;
import org.optaplanner.core.config.localsearch.decider.acceptor.LocalSearchAcceptorConfig;
import org.optaplanner.core.config.score.director.ScoreDirectorFactoryConfig;
import org.optaplanner.core.config.solver.SolverConfig;
import org.optaplanner.core.config.solver.termination.TerminationConfig;
import org.optaplanner.examples.common.app.CommonApp;
import org.optaplanner.examples.nqueens.domain.NQueens;
import org.optaplanner.examples.nqueens.domain.Queen;
import org.optaplanner.examples.nqueens.persistence.NQueensXmlSolutionFileIO;
import org.optaplanner.examples.nqueens.swingui.NQueensPanel;
import org.optaplanner.persistence.common.api.domain.solution.SolutionFileIO;

public class NQueensApp
extends CommonApp<NQueens> {
    public static final String SOLVER_CONFIG = "org/optaplanner/examples/nqueens/solver/nqueensSolverConfig.xml";
    public static final String DATA_DIR_NAME = "nqueens";

    public static void main(String[] args) {
        NQueensApp.prepareSwingEnvironment();
        new NQueensApp().init();
    }

    public NQueensApp() {
        super("N queens", "Place queens on a chessboard.\n\nNo 2 queens must be able to attack each other.", SOLVER_CONFIG, DATA_DIR_NAME, "/org/optaplanner/examples/nqueens/swingui/nqueensLogo.png");
    }

    @Override
    protected SolverFactory<NQueens> createSolverFactory() {
        return this.createSolverFactoryByXml();
    }

    protected SolverFactory<NQueens> createSolverFactoryByXml() {
        return SolverFactory.createFromXmlResource((String)SOLVER_CONFIG);
    }

    protected SolverFactory<NQueens> createSolverFactoryByApi() {
        SolverConfig solverConfig = new SolverConfig();
        solverConfig.setSolutionClass(NQueens.class);
        solverConfig.setEntityClassList(Collections.singletonList(Queen.class));
        ScoreDirectorFactoryConfig scoreDirectorFactoryConfig = new ScoreDirectorFactoryConfig();
        scoreDirectorFactoryConfig.setScoreDrlList(Arrays.asList("org/optaplanner/examples/nqueens/solver/nQueensConstraints.drl"));
        solverConfig.setScoreDirectorFactoryConfig(scoreDirectorFactoryConfig);
        solverConfig.setTerminationConfig(new TerminationConfig().withBestScoreLimit("0"));
        ArrayList<Object> phaseConfigList = new ArrayList<Object>();
        ConstructionHeuristicPhaseConfig constructionHeuristicPhaseConfig = new ConstructionHeuristicPhaseConfig();
        constructionHeuristicPhaseConfig.setConstructionHeuristicType(ConstructionHeuristicType.FIRST_FIT_DECREASING);
        phaseConfigList.add(constructionHeuristicPhaseConfig);
        LocalSearchPhaseConfig localSearchPhaseConfig = new LocalSearchPhaseConfig();
        ChangeMoveSelectorConfig changeMoveSelectorConfig = new ChangeMoveSelectorConfig();
        changeMoveSelectorConfig.setSelectionOrder(SelectionOrder.ORIGINAL);
        localSearchPhaseConfig.setMoveSelectorConfig((MoveSelectorConfig)changeMoveSelectorConfig);
        localSearchPhaseConfig.setAcceptorConfig(new LocalSearchAcceptorConfig().withEntityTabuSize(Integer.valueOf(5)));
        phaseConfigList.add(localSearchPhaseConfig);
        solverConfig.setPhaseConfigList(phaseConfigList);
        return SolverFactory.create((SolverConfig)solverConfig);
    }

    protected NQueensPanel createSolutionPanel() {
        return new NQueensPanel();
    }

    @Override
    public SolutionFileIO<NQueens> createSolutionFileIO() {
        return new NQueensXmlSolutionFileIO();
    }
}

