/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.experimental.impl;

import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.stream.IntStream;
import org.optaplanner.examples.common.experimental.impl.Interval;

public class IntervalSplitPoint<Interval_, Point_ extends Comparable<Point_>>
implements Comparable<IntervalSplitPoint<Interval_, Point_>> {
    final Point_ splitPoint;
    Map<Interval_, Integer> startIntervalToCountMap;
    Map<Interval_, Integer> endIntervalToCountMap;
    TreeSet<Interval<Interval_, Point_>> intervalsStartingAtSplitPointSet;
    TreeSet<Interval<Interval_, Point_>> intervalsEndingAtSplitPointSet;

    public IntervalSplitPoint(Point_ splitPoint) {
        this.splitPoint = splitPoint;
    }

    protected void createCollections() {
        this.startIntervalToCountMap = new IdentityHashMap<Interval_, Integer>();
        this.endIntervalToCountMap = new IdentityHashMap<Interval_, Integer>();
        this.intervalsStartingAtSplitPointSet = new TreeSet<Interval>(Comparator.comparing(Interval::getEnd).thenComparingInt(interval -> System.identityHashCode(interval.getValue())));
        this.intervalsEndingAtSplitPointSet = new TreeSet<Interval>(Comparator.comparing(Interval::getStart).thenComparingInt(interval -> System.identityHashCode(interval.getValue())));
    }

    public boolean addIntervalStartingAtSplitPoint(Interval<Interval_, Point_> interval) {
        this.startIntervalToCountMap.merge(interval.getValue(), 1, Integer::sum);
        return this.intervalsStartingAtSplitPointSet.add(interval);
    }

    public void removeIntervalStartingAtSplitPoint(Interval<Interval_, Point_> interval) {
        Integer newCount = this.startIntervalToCountMap.computeIfPresent(interval.getValue(), (key, count) -> {
            if (count > 1) {
                return count - 1;
            }
            return null;
        });
        if (null == newCount) {
            this.intervalsStartingAtSplitPointSet.remove(interval);
        }
    }

    public boolean addIntervalEndingAtSplitPoint(Interval<Interval_, Point_> interval) {
        this.endIntervalToCountMap.merge(interval.getValue(), 1, Integer::sum);
        return this.intervalsEndingAtSplitPointSet.add(interval);
    }

    public void removeIntervalEndingAtSplitPoint(Interval<Interval_, Point_> interval) {
        Integer newCount = this.endIntervalToCountMap.computeIfPresent(interval.getValue(), (key, count) -> {
            if (count > 1) {
                return count - 1;
            }
            return null;
        });
        if (null == newCount) {
            this.intervalsEndingAtSplitPointSet.remove(interval);
        }
    }

    public boolean containsIntervalStarting(Interval<Interval_, Point_> interval) {
        return this.intervalsStartingAtSplitPointSet.contains(interval);
    }

    public boolean containsIntervalEnding(Interval<Interval_, Point_> interval) {
        return this.intervalsEndingAtSplitPointSet.contains(interval);
    }

    public Iterator<Interval_> getValuesStartingFromSplitPointIterator() {
        return this.intervalsStartingAtSplitPointSet.stream().flatMap(interval -> IntStream.range(0, this.startIntervalToCountMap.get(interval.getValue())).mapToObj(index -> interval.getValue())).iterator();
    }

    public boolean isEmpty() {
        return this.intervalsStartingAtSplitPointSet.isEmpty() && this.intervalsEndingAtSplitPointSet.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntervalSplitPoint that = (IntervalSplitPoint)o;
        return this.splitPoint.equals(that.splitPoint);
    }

    public boolean isBefore(IntervalSplitPoint<Interval_, Point_> other) {
        return this.compareTo(other) < 0;
    }

    public boolean isAfter(IntervalSplitPoint<Interval_, Point_> other) {
        return this.compareTo(other) > 0;
    }

    public int hashCode() {
        return Objects.hash(this.splitPoint);
    }

    @Override
    public int compareTo(IntervalSplitPoint<Interval_, Point_> other) {
        return this.splitPoint.compareTo(other.splitPoint);
    }

    public String toString() {
        return this.splitPoint.toString();
    }
}

