/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.nqueens.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.variable.PlanningVariable;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.nqueens.domain.Column;
import org.optaplanner.examples.nqueens.domain.Row;
import org.optaplanner.examples.nqueens.domain.solver.QueenDifficultyWeightFactory;
import org.optaplanner.examples.nqueens.domain.solver.RowStrengthWeightFactory;

@PlanningEntity(difficultyWeightFactoryClass=QueenDifficultyWeightFactory.class)
public class Queen
extends AbstractPersistable {
    private Column column;
    private Row row;

    public Queen() {
    }

    public Queen(long id) {
        super(id);
    }

    public Queen(long id, Row row, Column column) {
        this(id);
        this.row = row;
        this.column = column;
    }

    public Column getColumn() {
        return this.column;
    }

    public void setColumn(Column column) {
        this.column = column;
    }

    @PlanningVariable(strengthWeightFactoryClass=RowStrengthWeightFactory.class)
    public Row getRow() {
        return this.row;
    }

    public void setRow(Row row) {
        this.row = row;
    }

    @JsonIgnore
    public int getColumnIndex() {
        return this.column.getIndex();
    }

    @JsonIgnore
    public int getRowIndex() {
        if (this.row == null) {
            return Integer.MIN_VALUE;
        }
        return this.row.getIndex();
    }

    @JsonIgnore
    public int getAscendingDiagonalIndex() {
        return this.getColumnIndex() + this.getRowIndex();
    }

    @JsonIgnore
    public int getDescendingDiagonalIndex() {
        return this.getColumnIndex() - this.getRowIndex();
    }

    @Override
    public String toString() {
        return "Queen-" + this.column.getIndex();
    }
}

