/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.examination.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.optaplanner.core.api.domain.constraintweight.ConstraintConfiguration;
import org.optaplanner.core.api.domain.constraintweight.ConstraintWeight;
import org.optaplanner.core.api.score.buildin.hardsoft.HardSoftScore;
import org.optaplanner.examples.common.domain.AbstractPersistable;

@ConstraintConfiguration(constraintPackage="org.optaplanner.examples.examination.score")
public class ExaminationConstraintConfiguration
extends AbstractPersistable {
    private int conflictingExamsInSamePeriodPenalty = 1;
    private int periodDurationTooShortPenalty = 1;
    private int roomCapacityTooSmallPenalty = 1;
    private int periodPenaltyExamCoincidencePenalty = 1;
    private int periodPenaltyExclusionPenalty = 1;
    private int periodPenaltyAfterPenalty = 1;
    private int roomPenaltyExclusivePenalty = 1;
    private int twoInARowPenalty;
    private int twoInADayPenalty;
    private int periodSpreadLength;
    private int periodSpreadPenalty;
    private int mixedDurationPenalty;
    private int frontLoadLargeTopicSize;
    private int frontLoadLastPeriodSize;
    private int frontLoadPenalty;
    private int periodPenaltyPenalty = 1;
    private int roomPenaltyPenalty = 1;

    public ExaminationConstraintConfiguration() {
    }

    public ExaminationConstraintConfiguration(long id) {
        super(id);
    }

    @ConstraintWeight(value="conflictingExamsInSamePeriod")
    @JsonIgnore
    public HardSoftScore getConflictingExamsInSamePeriodPenaltyAsScore() {
        return HardSoftScore.ofHard((int)this.conflictingExamsInSamePeriodPenalty);
    }

    @ConstraintWeight(value="periodDurationTooShort")
    @JsonIgnore
    public HardSoftScore getPeriodDurationTooShortPenaltyAsScore() {
        return HardSoftScore.ofHard((int)this.periodDurationTooShortPenalty);
    }

    @ConstraintWeight(value="roomCapacityTooSmall")
    @JsonIgnore
    public HardSoftScore getRoomCapacityTooSmallPenaltyAsScore() {
        return HardSoftScore.ofHard((int)this.roomCapacityTooSmallPenalty);
    }

    @ConstraintWeight(value="periodPenaltyExamCoincidence")
    @JsonIgnore
    public HardSoftScore getPeriodPenaltyExamCoincidencePenaltyAsScore() {
        return HardSoftScore.ofHard((int)this.periodPenaltyExamCoincidencePenalty);
    }

    @ConstraintWeight(value="periodPenaltyExclusion")
    @JsonIgnore
    public HardSoftScore getPeriodPenaltyExclusionPenaltyAsScore() {
        return HardSoftScore.ofHard((int)this.periodPenaltyExclusionPenalty);
    }

    @ConstraintWeight(value="periodPenaltyAfter")
    @JsonIgnore
    public HardSoftScore getPeriodPenaltyAfterPenaltyAsScore() {
        return HardSoftScore.ofHard((int)this.periodPenaltyAfterPenalty);
    }

    @ConstraintWeight(value="roomPenaltyExclusive")
    @JsonIgnore
    public HardSoftScore getRoomPenaltyExclusivePenaltyAsScore() {
        return HardSoftScore.ofHard((int)this.roomPenaltyExclusivePenalty);
    }

    @ConstraintWeight(value="twoExamsInARow")
    @JsonIgnore
    public HardSoftScore getTwoInARowPenaltyAsScore() {
        return HardSoftScore.ofSoft((int)this.twoInARowPenalty);
    }

    @ConstraintWeight(value="twoExamsInADay")
    @JsonIgnore
    public HardSoftScore getTwoInADayPenaltyAsScore() {
        return HardSoftScore.ofSoft((int)this.twoInADayPenalty);
    }

    @ConstraintWeight(value="periodSpread")
    @JsonIgnore
    public HardSoftScore getPeriodSpreadPenaltyAsScore() {
        return HardSoftScore.ofSoft((int)this.periodSpreadPenalty);
    }

    @ConstraintWeight(value="mixedDurations")
    @JsonIgnore
    public HardSoftScore getMixedDurationPenaltyAsScore() {
        return HardSoftScore.ofSoft((int)this.mixedDurationPenalty);
    }

    @ConstraintWeight(value="frontLoad")
    @JsonIgnore
    public HardSoftScore getFrontLoadPenaltyAsScore() {
        return HardSoftScore.ofSoft((int)this.frontLoadPenalty);
    }

    @ConstraintWeight(value="periodPenalty")
    @JsonIgnore
    public HardSoftScore getPeriodPenaltyPenaltyAsScore() {
        return HardSoftScore.ofSoft((int)this.periodPenaltyPenalty);
    }

    @ConstraintWeight(value="roomPenalty")
    @JsonIgnore
    public HardSoftScore getRoomPenaltyPenaltyAsScore() {
        return HardSoftScore.ofSoft((int)this.roomPenaltyPenalty);
    }

    public int getConflictingExamsInSamePeriodPenalty() {
        return this.conflictingExamsInSamePeriodPenalty;
    }

    public void setConflictingExamsInSamePeriodPenalty(int conflictingExamsInSamePeriodPenalty) {
        this.conflictingExamsInSamePeriodPenalty = conflictingExamsInSamePeriodPenalty;
    }

    public int getPeriodDurationTooShortPenalty() {
        return this.periodDurationTooShortPenalty;
    }

    public void setPeriodDurationTooShortPenalty(int periodDurationTooShortPenalty) {
        this.periodDurationTooShortPenalty = periodDurationTooShortPenalty;
    }

    public int getRoomCapacityTooSmallPenalty() {
        return this.roomCapacityTooSmallPenalty;
    }

    public void setRoomCapacityTooSmallPenalty(int roomCapacityTooSmallPenalty) {
        this.roomCapacityTooSmallPenalty = roomCapacityTooSmallPenalty;
    }

    public int getPeriodPenaltyExamCoincidencePenalty() {
        return this.periodPenaltyExamCoincidencePenalty;
    }

    public void setPeriodPenaltyExamCoincidencePenalty(int periodPenaltyExamCoincidencePenalty) {
        this.periodPenaltyExamCoincidencePenalty = periodPenaltyExamCoincidencePenalty;
    }

    public int getPeriodPenaltyExclusionPenalty() {
        return this.periodPenaltyExclusionPenalty;
    }

    public void setPeriodPenaltyExclusionPenalty(int periodPenaltyExclusionPenalty) {
        this.periodPenaltyExclusionPenalty = periodPenaltyExclusionPenalty;
    }

    public int getPeriodPenaltyAfterPenalty() {
        return this.periodPenaltyAfterPenalty;
    }

    public void setPeriodPenaltyAfterPenalty(int periodPenaltyAfterPenalty) {
        this.periodPenaltyAfterPenalty = periodPenaltyAfterPenalty;
    }

    public int getRoomPenaltyExclusivePenalty() {
        return this.roomPenaltyExclusivePenalty;
    }

    public void setRoomPenaltyExclusivePenalty(int roomPenaltyExclusivePenalty) {
        this.roomPenaltyExclusivePenalty = roomPenaltyExclusivePenalty;
    }

    public int getTwoInARowPenalty() {
        return this.twoInARowPenalty;
    }

    public void setTwoInARowPenalty(int twoInARowPenalty) {
        this.twoInARowPenalty = twoInARowPenalty;
    }

    public int getTwoInADayPenalty() {
        return this.twoInADayPenalty;
    }

    public void setTwoInADayPenalty(int twoInADayPenalty) {
        this.twoInADayPenalty = twoInADayPenalty;
    }

    public int getPeriodSpreadLength() {
        return this.periodSpreadLength;
    }

    public void setPeriodSpreadLength(int periodSpreadLength) {
        this.periodSpreadLength = periodSpreadLength;
    }

    public int getPeriodSpreadPenalty() {
        return this.periodSpreadPenalty;
    }

    public void setPeriodSpreadPenalty(int periodSpreadPenalty) {
        this.periodSpreadPenalty = periodSpreadPenalty;
    }

    public int getMixedDurationPenalty() {
        return this.mixedDurationPenalty;
    }

    public void setMixedDurationPenalty(int mixedDurationPenalty) {
        this.mixedDurationPenalty = mixedDurationPenalty;
    }

    public int getFrontLoadLargeTopicSize() {
        return this.frontLoadLargeTopicSize;
    }

    public void setFrontLoadLargeTopicSize(int frontLoadLargeTopicSize) {
        this.frontLoadLargeTopicSize = frontLoadLargeTopicSize;
    }

    public int getFrontLoadLastPeriodSize() {
        return this.frontLoadLastPeriodSize;
    }

    public void setFrontLoadLastPeriodSize(int frontLoadLastPeriodSize) {
        this.frontLoadLastPeriodSize = frontLoadLastPeriodSize;
    }

    public int getFrontLoadPenalty() {
        return this.frontLoadPenalty;
    }

    public void setFrontLoadPenalty(int frontLoadPenalty) {
        this.frontLoadPenalty = frontLoadPenalty;
    }

    public int getPeriodPenaltyPenalty() {
        return this.periodPenaltyPenalty;
    }

    public void setPeriodPenaltyPenalty(int periodPenaltyPenalty) {
        this.periodPenaltyPenalty = periodPenaltyPenalty;
    }

    public int getRoomPenaltyPenalty() {
        return this.roomPenaltyPenalty;
    }

    public void setRoomPenaltyPenalty(int roomPenaltyPenalty) {
        this.roomPenaltyPenalty = roomPenaltyPenalty;
    }

    public ExaminationConstraintConfiguration withConflictingExamsInSamePeriodPenalty(int conflictingExamsInSamePeriodPenalty) {
        this.setConflictingExamsInSamePeriodPenalty(conflictingExamsInSamePeriodPenalty);
        return this;
    }

    public ExaminationConstraintConfiguration withPeriodDurationTooShortPenalty(int periodDurationTooShortPenalty) {
        this.setPeriodDurationTooShortPenalty(periodDurationTooShortPenalty);
        return this;
    }

    public ExaminationConstraintConfiguration withRoomCapacityTooSmallPenalty(int roomCapacityTooSmallPenalty) {
        this.setRoomCapacityTooSmallPenalty(roomCapacityTooSmallPenalty);
        return this;
    }

    public ExaminationConstraintConfiguration withPeriodPenaltyExamCoincidencePenalty(int periodPenaltyExamCoincidencePenalty) {
        this.setPeriodPenaltyExamCoincidencePenalty(periodPenaltyExamCoincidencePenalty);
        return this;
    }

    public ExaminationConstraintConfiguration withPeriodPenaltyExclusionPenalty(int periodPenaltyExclusionPenalty) {
        this.setPeriodPenaltyExclusionPenalty(periodPenaltyExclusionPenalty);
        return this;
    }

    public ExaminationConstraintConfiguration withPeriodPenaltyAfterPenalty(int periodPenaltyAfterPenalty) {
        this.setPeriodPenaltyAfterPenalty(periodPenaltyAfterPenalty);
        return this;
    }

    public ExaminationConstraintConfiguration withRoomPenaltyExclusivePenalty(int roomPenaltyExclusivePenalty) {
        this.setRoomPenaltyExclusivePenalty(roomPenaltyExclusivePenalty);
        return this;
    }

    public ExaminationConstraintConfiguration withTwoInARowPenalty(int twoInARowPenalty) {
        this.setTwoInARowPenalty(twoInARowPenalty);
        return this;
    }

    public ExaminationConstraintConfiguration withTwoInADayPenalty(int twoInADayPenalty) {
        this.setTwoInADayPenalty(twoInADayPenalty);
        return this;
    }

    public ExaminationConstraintConfiguration withPeriodSpreadLength(int periodSpreadLength) {
        this.setPeriodSpreadLength(periodSpreadLength);
        return this;
    }

    public ExaminationConstraintConfiguration withPeriodSpreadPenalty(int periodSpreadPenalty) {
        this.setPeriodSpreadPenalty(periodSpreadPenalty);
        return this;
    }

    public ExaminationConstraintConfiguration withMixedDurationPenalty(int mixedDurationPenalty) {
        this.setMixedDurationPenalty(mixedDurationPenalty);
        return this;
    }

    public ExaminationConstraintConfiguration withFrontLoadLargeTopicSize(int frontLoadLargeTopicSize) {
        this.setFrontLoadLargeTopicSize(frontLoadLargeTopicSize);
        return this;
    }

    public ExaminationConstraintConfiguration withFrontLoadLastPeriodSize(int frontLoadLastPeriodSize) {
        this.setFrontLoadLastPeriodSize(frontLoadLastPeriodSize);
        return this;
    }

    public ExaminationConstraintConfiguration withFrontLoadPenalty(int frontLoadPenalty) {
        this.setFrontLoadPenalty(frontLoadPenalty);
        return this;
    }

    public ExaminationConstraintConfiguration withPeriodPenaltyPenalty(int periodPenaltyPenalty) {
        this.setPeriodPenaltyPenalty(periodPenaltyPenalty);
        return this;
    }

    public ExaminationConstraintConfiguration withRoomPenaltyPenalty(int roomPenaltyPenalty) {
        this.setRoomPenaltyPenalty(roomPenaltyPenalty);
        return this;
    }
}

