/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.flightcrewscheduling.domain;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.Comparator;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.flightcrewscheduling.domain.Airport;

public class Flight
extends AbstractPersistable
implements Comparable<Flight> {
    private static final Comparator<Flight> COMPARATOR = Comparator.comparing(Flight::getDepartureUTCDateTime).thenComparing(Flight::getDepartureAirport).thenComparing(Flight::getArrivalUTCDateTime).thenComparing(Flight::getArrivalAirport).thenComparing(Flight::getFlightNumber);
    private String flightNumber;
    private Airport departureAirport;
    private LocalDateTime departureUTCDateTime;
    private Airport arrivalAirport;
    private LocalDateTime arrivalUTCDateTime;

    public Flight() {
    }

    public Flight(long id, String flightNumber, Airport departureAirport, LocalDateTime departureUTCDateTime, Airport arrivalAirport, LocalDateTime arrivalUTCDateTime) {
        super(id);
        this.flightNumber = flightNumber;
        this.departureAirport = departureAirport;
        this.departureUTCDateTime = departureUTCDateTime;
        this.arrivalAirport = arrivalAirport;
        this.arrivalUTCDateTime = arrivalUTCDateTime;
    }

    public long getDurationInMinutes() {
        return ChronoUnit.MINUTES.between(this.departureUTCDateTime, this.arrivalUTCDateTime);
    }

    public LocalDate getDepartureUTCDate() {
        return this.departureUTCDateTime.toLocalDate();
    }

    public LocalTime getDepartureUTCTime() {
        return this.departureUTCDateTime.toLocalTime();
    }

    public LocalDate getArrivalUTCDate() {
        return this.arrivalUTCDateTime.toLocalDate();
    }

    public LocalTime getArrivalUTCTime() {
        return this.arrivalUTCDateTime.toLocalTime();
    }

    public boolean overlaps(Flight other) {
        return this.departureUTCDateTime.compareTo(other.arrivalUTCDateTime) < 0 && other.departureUTCDateTime.compareTo(this.arrivalUTCDateTime) < 0;
    }

    @Override
    public String toString() {
        return this.flightNumber + "@" + this.departureUTCDateTime.toLocalDate();
    }

    public String getFlightNumber() {
        return this.flightNumber;
    }

    public void setFlightNumber(String flightNumber) {
        this.flightNumber = flightNumber;
    }

    public Airport getDepartureAirport() {
        return this.departureAirport;
    }

    public void setDepartureAirport(Airport departureAirport) {
        this.departureAirport = departureAirport;
    }

    public LocalDateTime getDepartureUTCDateTime() {
        return this.departureUTCDateTime;
    }

    public void setDepartureUTCDateTime(LocalDateTime departureUTCDateTime) {
        this.departureUTCDateTime = departureUTCDateTime;
    }

    public Airport getArrivalAirport() {
        return this.arrivalAirport;
    }

    public void setArrivalAirport(Airport arrivalAirport) {
        this.arrivalAirport = arrivalAirport;
    }

    public LocalDateTime getArrivalUTCDateTime() {
        return this.arrivalUTCDateTime;
    }

    public void setArrivalUTCDateTime(LocalDateTime arrivalUTCDateTime) {
        this.arrivalUTCDateTime = arrivalUTCDateTime;
    }

    @Override
    public int compareTo(Flight o) {
        return COMPARATOR.compare(this, o);
    }
}

