/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.swingui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.constraint.ConstraintMatch;
import org.optaplanner.core.api.score.constraint.Indictment;
import org.optaplanner.core.api.solver.change.ProblemChange;
import org.optaplanner.examples.common.business.SolutionBusiness;
import org.optaplanner.examples.common.swingui.SolverAndPersistenceFrame;
import org.optaplanner.swing.impl.TangoColorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SolutionPanel<Solution_>
extends JPanel
implements Scrollable {
    protected static final String USAGE_EXPLANATION_PATH = "/org/optaplanner/examples/common/swingui/exampleUsageExplanation.png";
    public static final Dimension PREFERRED_SCROLLABLE_VIEWPORT_SIZE = new Dimension(800, 600);
    protected static final Color[][] INDICTMENT_COLORS = new Color[][]{{TangoColorFactory.SCARLET_3, TangoColorFactory.SCARLET_1}, {TangoColorFactory.ORANGE_3, TangoColorFactory.ORANGE_1}, {TangoColorFactory.BUTTER_3, TangoColorFactory.BUTTER_1}, {TangoColorFactory.CHAMELEON_3, TangoColorFactory.CHAMELEON_1}, {TangoColorFactory.SKY_BLUE_3, TangoColorFactory.SKY_BLUE_1}, {TangoColorFactory.PLUM_3, TangoColorFactory.PLUM_1}};
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected SolverAndPersistenceFrame<Solution_> solverAndPersistenceFrame;
    protected SolutionBusiness<Solution_, ?> solutionBusiness;
    protected boolean useIndictmentColor = false;
    protected TangoColorFactory normalColorFactory;
    protected double[] indictmentMinimumLevelNumbers;

    public SolverAndPersistenceFrame<Solution_> getSolverAndPersistenceFrame() {
        return this.solverAndPersistenceFrame;
    }

    public void setSolverAndPersistenceFrame(SolverAndPersistenceFrame<Solution_> solverAndPersistenceFrame) {
        this.solverAndPersistenceFrame = solverAndPersistenceFrame;
    }

    public SolutionBusiness<Solution_, ?> getSolutionBusiness() {
        return this.solutionBusiness;
    }

    public void setSolutionBusiness(SolutionBusiness<Solution_, ?> solutionBusiness) {
        this.solutionBusiness = solutionBusiness;
    }

    public boolean isUseIndictmentColor() {
        return this.useIndictmentColor;
    }

    public void setUseIndictmentColor(boolean useIndictmentColor) {
        this.useIndictmentColor = useIndictmentColor;
    }

    public String getUsageExplanationPath() {
        return USAGE_EXPLANATION_PATH;
    }

    public boolean isWrapInScrollPane() {
        return true;
    }

    public abstract void resetPanel(Solution_ var1);

    public void updatePanel(Solution_ solution) {
        this.resetPanel(solution);
    }

    public Solution_ getSolution() {
        return this.solutionBusiness.getSolution();
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return PREFERRED_SCROLLABLE_VIEWPORT_SIZE;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 20;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 20;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        if (this.getParent() instanceof JViewport) {
            return this.getParent().getWidth() > this.getPreferredSize().width;
        }
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        if (this.getParent() instanceof JViewport) {
            return this.getParent().getHeight() > this.getPreferredSize().height;
        }
        return false;
    }

    public boolean isIndictmentHeatMapEnabled() {
        return false;
    }

    protected void preparePlanningEntityColors(List<?> planningEntityList) {
        if (this.useIndictmentColor) {
            this.indictmentMinimumLevelNumbers = null;
            for (Object planningEntity : planningEntityList) {
                int i;
                Indictment<?> indictment = this.solutionBusiness.getIndictmentMap().get(planningEntity);
                if (indictment == null) continue;
                Number[] levelNumbers = indictment.getScore().toLevelNumbers();
                if (this.indictmentMinimumLevelNumbers == null) {
                    this.indictmentMinimumLevelNumbers = new double[levelNumbers.length];
                    for (i = 0; i < levelNumbers.length; ++i) {
                        this.indictmentMinimumLevelNumbers[i] = levelNumbers[i].doubleValue();
                    }
                    continue;
                }
                for (i = 0; i < levelNumbers.length; ++i) {
                    double levelNumber = levelNumbers[i].doubleValue();
                    if (!(levelNumber < this.indictmentMinimumLevelNumbers[i])) continue;
                    this.indictmentMinimumLevelNumbers[i] = levelNumber;
                }
            }
        } else {
            this.normalColorFactory = new TangoColorFactory();
        }
    }

    public Color determinePlanningEntityColor(Object planningEntity, Object normalColorObject) {
        if (this.useIndictmentColor) {
            Indictment<?> indictment = this.solutionBusiness.getIndictmentMap().get(planningEntity);
            if (indictment != null) {
                Number[] levelNumbers = indictment.getScore().toLevelNumbers();
                for (int i = 0; i < levelNumbers.length; ++i) {
                    if (i > INDICTMENT_COLORS.length) {
                        return TangoColorFactory.ALUMINIUM_3;
                    }
                    double levelNumber = levelNumbers[i].doubleValue();
                    if (!(levelNumber < 0.0)) continue;
                    return TangoColorFactory.buildPercentageColor((Color)INDICTMENT_COLORS[i][0], (Color)INDICTMENT_COLORS[i][1], (double)(1.0 - levelNumber / this.indictmentMinimumLevelNumbers[i]));
                }
            }
            return Color.WHITE;
        }
        return this.normalColorFactory.pickColor(normalColorObject);
    }

    public String determinePlanningEntityTooltip(Object planningEntity) {
        Indictment<?> indictment = this.solutionBusiness.getIndictmentMap().get(planningEntity);
        if (indictment == null) {
            return "<html>No indictment</html>";
        }
        StringBuilder s = new StringBuilder("<html>Indictment: ").append(indictment.getScore().toShortString());
        for (ConstraintMatch constraintMatch : indictment.getConstraintMatchSet()) {
            s.append("<br/>&nbsp;&nbsp;").append(constraintMatch.getConstraintName()).append(" = ").append(constraintMatch.getScore().toShortString());
        }
        s.append("</html>");
        return s.toString();
    }

    public void doProblemChange(ProblemChange<Solution_> problemChange) {
        this.doProblemChange(problemChange, false);
    }

    public void doProblemChange(ProblemChange<Solution_> problemChange, boolean reset) {
        this.solutionBusiness.doProblemChange(problemChange);
        Solution_ solution = this.getSolution();
        Object score = this.solutionBusiness.getScore();
        if (reset) {
            this.resetPanel(solution);
        } else {
            this.updatePanel(solution);
        }
        this.validate();
        this.solverAndPersistenceFrame.refreshScoreField((Score)score);
    }
}

