/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.projectjobscheduling.domain;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.common.persistence.jackson.JacksonUniqueIdGenerator;
import org.optaplanner.examples.common.swingui.components.Labeled;
import org.optaplanner.examples.projectjobscheduling.domain.Job;
import org.optaplanner.examples.projectjobscheduling.domain.resource.LocalResource;

@JsonIdentityInfo(generator=JacksonUniqueIdGenerator.class)
public class Project
extends AbstractPersistable
implements Labeled {
    private int releaseDate;
    private int criticalPathDuration;
    private List<LocalResource> localResourceList;
    private List<Job> jobList;

    public Project() {
    }

    public Project(long id, int releaseDate, int criticalPathDuration) {
        super(id);
        this.releaseDate = releaseDate;
        this.criticalPathDuration = criticalPathDuration;
    }

    public int getReleaseDate() {
        return this.releaseDate;
    }

    public void setReleaseDate(int releaseDate) {
        this.releaseDate = releaseDate;
    }

    public int getCriticalPathDuration() {
        return this.criticalPathDuration;
    }

    public void setCriticalPathDuration(int criticalPathDuration) {
        this.criticalPathDuration = criticalPathDuration;
    }

    public List<LocalResource> getLocalResourceList() {
        return this.localResourceList;
    }

    public void setLocalResourceList(List<LocalResource> localResourceList) {
        this.localResourceList = localResourceList;
    }

    public List<Job> getJobList() {
        return this.jobList;
    }

    public void setJobList(List<Job> jobList) {
        this.jobList = jobList;
    }

    @JsonIgnore
    public int getCriticalPathEndDate() {
        return this.releaseDate + this.criticalPathDuration;
    }

    @Override
    public String getLabel() {
        return "Project " + this.id;
    }
}

