/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.vehiclerouting.swingui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.swing.ImageIcon;
import org.optaplanner.core.api.score.buildin.hardsoftlong.HardSoftLongScore;
import org.optaplanner.examples.common.swingui.latitudelongitude.LatitudeLongitudeTranslator;
import org.optaplanner.examples.vehiclerouting.domain.Customer;
import org.optaplanner.examples.vehiclerouting.domain.Depot;
import org.optaplanner.examples.vehiclerouting.domain.Vehicle;
import org.optaplanner.examples.vehiclerouting.domain.VehicleRoutingSolution;
import org.optaplanner.examples.vehiclerouting.domain.location.AirLocation;
import org.optaplanner.examples.vehiclerouting.domain.location.DistanceType;
import org.optaplanner.examples.vehiclerouting.domain.location.Location;
import org.optaplanner.examples.vehiclerouting.domain.timewindowed.TimeWindowedCustomer;
import org.optaplanner.examples.vehiclerouting.domain.timewindowed.TimeWindowedDepot;
import org.optaplanner.examples.vehiclerouting.domain.timewindowed.TimeWindowedVehicleRoutingSolution;
import org.optaplanner.swing.impl.TangoColorFactory;

public class VehicleRoutingSolutionPainter {
    private static final int TEXT_SIZE = 12;
    private static final int TIME_WINDOW_DIAMETER = 26;
    private static final NumberFormat NUMBER_FORMAT = new DecimalFormat("#,##0.00");
    private static final String IMAGE_PATH_PREFIX = "/org/optaplanner/examples/vehiclerouting/swingui/";
    private ImageIcon depotImageIcon = new ImageIcon(this.getClass().getResource("/org/optaplanner/examples/vehiclerouting/swingui/depot.png"));
    private ImageIcon[] vehicleImageIcons = new ImageIcon[]{new ImageIcon(this.getClass().getResource("/org/optaplanner/examples/vehiclerouting/swingui/vehicleChameleon.png")), new ImageIcon(this.getClass().getResource("/org/optaplanner/examples/vehiclerouting/swingui/vehicleButter.png")), new ImageIcon(this.getClass().getResource("/org/optaplanner/examples/vehiclerouting/swingui/vehicleSkyBlue.png")), new ImageIcon(this.getClass().getResource("/org/optaplanner/examples/vehiclerouting/swingui/vehicleChocolate.png")), new ImageIcon(this.getClass().getResource("/org/optaplanner/examples/vehiclerouting/swingui/vehiclePlum.png"))};
    private BufferedImage canvas = null;
    private LatitudeLongitudeTranslator translator = null;
    private Long minimumTimeWindowTime = null;
    private Long maximumTimeWindowTime = null;

    public VehicleRoutingSolutionPainter() {
        int sequenceSize = TangoColorFactory.SEQUENCE_1.size();
        if (this.vehicleImageIcons.length != sequenceSize) {
            throw new IllegalStateException("The vehicleImageIcons length (" + this.vehicleImageIcons.length + ") should be equal to the TangoColorFactory.SEQUENCE length (" + sequenceSize + ").");
        }
    }

    public BufferedImage getCanvas() {
        return this.canvas;
    }

    public LatitudeLongitudeTranslator getTranslator() {
        return this.translator;
    }

    public void reset(VehicleRoutingSolution solution, Dimension size, ImageObserver imageObserver) {
        this.translator = new LatitudeLongitudeTranslator();
        for (Location location : solution.getLocationList()) {
            this.translator.addCoordinates(location.getLatitude(), location.getLongitude());
        }
        this.determineMinimumAndMaximumTimeWindowTime(solution);
        double width = size.getWidth();
        double height = size.getHeight();
        this.translator.prepareFor(width, height - 10.0 - 12.0);
        Graphics2D g = this.createCanvas(width, height);
        g.setFont(g.getFont().deriveFont(12.0f));
        g.setStroke(TangoColorFactory.NORMAL_STROKE);
        for (Customer customer : solution.getCustomerList()) {
            Location location = customer.getLocation();
            int x = this.translator.translateLongitudeToX(location.getLongitude());
            int y = this.translator.translateLatitudeToY(location.getLatitude());
            g.setColor(TangoColorFactory.ALUMINIUM_4);
            g.fillRect(x - 1, y - 1, 3, 3);
            String demandString = Integer.toString(customer.getDemand());
            g.drawString(demandString, x - g.getFontMetrics().stringWidth(demandString) / 2, y - 6);
            if (!(customer instanceof TimeWindowedCustomer)) continue;
            TimeWindowedCustomer timeWindowedCustomer = (TimeWindowedCustomer)customer;
            g.setColor(TangoColorFactory.ALUMINIUM_3);
            int circleX = x - 13;
            int circleY = y + 5;
            g.drawOval(circleX, circleY, 26, 26);
            g.fillArc(circleX, circleY, 26, 26, 90 - this.calculateTimeWindowDegree(timeWindowedCustomer.getReadyTime()), this.calculateTimeWindowDegree(timeWindowedCustomer.getReadyTime()) - this.calculateTimeWindowDegree(timeWindowedCustomer.getDueTime()));
            if (timeWindowedCustomer.getArrivalTime() == null) continue;
            if (timeWindowedCustomer.isArrivalAfterDueTime()) {
                g.setColor(TangoColorFactory.SCARLET_2);
            } else if (timeWindowedCustomer.isArrivalBeforeReadyTime()) {
                g.setColor(TangoColorFactory.ORANGE_2);
            } else {
                g.setColor(TangoColorFactory.ALUMINIUM_6);
            }
            g.setStroke(TangoColorFactory.THICK_STROKE);
            int circleCenterY = y + 5 + 13;
            int angle = this.calculateTimeWindowDegree(timeWindowedCustomer.getArrivalTime());
            g.drawLine(x, circleCenterY, x + (int)(Math.sin(Math.toRadians(angle)) * 16.0), circleCenterY - (int)(Math.cos(Math.toRadians(angle)) * 16.0));
            g.setStroke(TangoColorFactory.NORMAL_STROKE);
        }
        g.setColor(TangoColorFactory.ALUMINIUM_3);
        for (Depot depot : solution.getDepotList()) {
            int x = this.translator.translateLongitudeToX(depot.getLocation().getLongitude());
            int y = this.translator.translateLatitudeToY(depot.getLocation().getLatitude());
            g.fillRect(x - 2, y - 2, 5, 5);
            g.drawImage(this.depotImageIcon.getImage(), x - this.depotImageIcon.getIconWidth() / 2, y - 2 - this.depotImageIcon.getIconHeight(), imageObserver);
        }
        int colorIndex = 0;
        for (Vehicle vehicle : solution.getVehicleList()) {
            g.setColor((Color)TangoColorFactory.SEQUENCE_2.get(colorIndex));
            Location previousVehicleInfoLocation = vehicle.getLocation();
            Location vehicleInfoLocation = null;
            long longestNonDepotDistance = -1L;
            int load = 0;
            for (int i = 0; i < vehicle.getCustomers().size(); ++i) {
                Customer customer = vehicle.getCustomers().get(i);
                load += customer.getDemand();
                Location previousLocation = i == 0 ? vehicle.getLocation() : vehicle.getCustomers().get(i - 1).getLocation();
                Location location = customer.getLocation();
                this.translator.drawRoute(g, previousLocation.getLongitude(), previousLocation.getLatitude(), location.getLongitude(), location.getLatitude(), location instanceof AirLocation, false);
                long distance = previousLocation.getDistanceTo(location);
                if (longestNonDepotDistance < distance) {
                    longestNonDepotDistance = distance;
                    previousVehicleInfoLocation = previousLocation;
                    vehicleInfoLocation = location;
                }
                if (i != vehicle.getCustomers().size() - 1) continue;
                Location vehicleLocation = vehicle.getLocation();
                this.translator.drawRoute(g, location.getLongitude(), location.getLatitude(), vehicleLocation.getLongitude(), vehicleLocation.getLatitude(), location instanceof AirLocation, true);
            }
            if (vehicleInfoLocation != null) {
                if (load > vehicle.getCapacity()) {
                    g.setColor(TangoColorFactory.SCARLET_2);
                }
                double longitude = (previousVehicleInfoLocation.getLongitude() + vehicleInfoLocation.getLongitude()) / 2.0;
                int x = this.translator.translateLongitudeToX(longitude);
                double latitude = (previousVehicleInfoLocation.getLatitude() + vehicleInfoLocation.getLatitude()) / 2.0;
                int y = this.translator.translateLatitudeToY(latitude);
                boolean ascending = previousVehicleInfoLocation.getLongitude() < vehicleInfoLocation.getLongitude() ^ previousVehicleInfoLocation.getLatitude() < vehicleInfoLocation.getLatitude();
                ImageIcon vehicleImageIcon = this.vehicleImageIcons[colorIndex];
                int vehicleInfoHeight = vehicleImageIcon.getIconHeight() + 2 + 12;
                g.drawImage(vehicleImageIcon.getImage(), x + 1, ascending ? y - vehicleInfoHeight - 1 : y + 1, imageObserver);
                g.drawString(load + " / " + vehicle.getCapacity(), x + 1, ascending ? y - 1 : y + vehicleInfoHeight + 1);
            }
            colorIndex = (colorIndex + 1) % TangoColorFactory.SEQUENCE_2.size();
        }
        g.setColor(TangoColorFactory.ALUMINIUM_3);
        g.fillRect(5, (int)height - 12 - 12 - 6, 5, 5);
        g.drawString("Depot", 15, (int)height - 10 - 12);
        String string = solution.getVehicleList().size() + " vehicles";
        g.drawString(string, ((int)width - g.getFontMetrics().stringWidth(string)) / 2, (int)height - 10 - 12);
        g.setColor(TangoColorFactory.ALUMINIUM_4);
        g.fillRect(6, (int)height - 6 - 6, 3, 3);
        g.drawString(solution instanceof TimeWindowedVehicleRoutingSolution ? "Customer: demand, time window and arrival time" : "Customer: demand", 15, (int)height - 5);
        String customersSizeString = solution.getCustomerList().size() + " customers";
        g.drawString(customersSizeString, ((int)width - g.getFontMetrics().stringWidth(customersSizeString)) / 2, (int)height - 5);
        if (solution.getDistanceType() == DistanceType.AIR_DISTANCE) {
            String clickString = "Right click anywhere on the map to add a customer.";
            g.drawString(clickString, (int)width - 5 - g.getFontMetrics().stringWidth(clickString), (int)height - 5);
        }
        g.setColor(TangoColorFactory.ORANGE_3);
        HardSoftLongScore score = solution.getScore();
        if (score != null) {
            String distanceString = !score.isFeasible() ? "Not feasible" : solution.getDistanceString(NUMBER_FORMAT);
            g.setFont(g.getFont().deriveFont(1, 24.0f));
            g.drawString(distanceString, (int)width - g.getFontMetrics().stringWidth(distanceString) - 10, (int)height - 10 - 12);
        }
    }

    private void determineMinimumAndMaximumTimeWindowTime(VehicleRoutingSolution solution) {
        long dueTime;
        long readyTime;
        this.minimumTimeWindowTime = Long.MAX_VALUE;
        this.maximumTimeWindowTime = Long.MIN_VALUE;
        for (Depot depot : solution.getDepotList()) {
            if (!(depot instanceof TimeWindowedDepot)) continue;
            TimeWindowedDepot timeWindowedDepot = (TimeWindowedDepot)depot;
            readyTime = timeWindowedDepot.getReadyTime();
            if (readyTime < this.minimumTimeWindowTime) {
                this.minimumTimeWindowTime = readyTime;
            }
            if ((dueTime = timeWindowedDepot.getDueTime()) <= this.maximumTimeWindowTime) continue;
            this.maximumTimeWindowTime = dueTime;
        }
        for (Customer customer : solution.getCustomerList()) {
            if (!(customer instanceof TimeWindowedCustomer)) continue;
            TimeWindowedCustomer timeWindowedCustomer = (TimeWindowedCustomer)customer;
            readyTime = timeWindowedCustomer.getReadyTime();
            if (readyTime < this.minimumTimeWindowTime) {
                this.minimumTimeWindowTime = readyTime;
            }
            if ((dueTime = timeWindowedCustomer.getDueTime()) <= this.maximumTimeWindowTime) continue;
            this.maximumTimeWindowTime = dueTime;
        }
    }

    private int calculateTimeWindowDegree(long timeWindowTime) {
        return (int)(360L * (timeWindowTime - this.minimumTimeWindowTime) / (this.maximumTimeWindowTime - this.minimumTimeWindowTime));
    }

    public Graphics2D createCanvas(double width, double height) {
        int canvasWidth = (int)Math.ceil(width) + 1;
        int canvasHeight = (int)Math.ceil(height) + 1;
        this.canvas = new BufferedImage(canvasWidth, canvasHeight, 1);
        Graphics2D g = this.canvas.createGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, canvasWidth, canvasHeight);
        return g;
    }
}

