/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.migration.jakarta;

import java.nio.file.Path;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.maven.ChangeDependencyGroupIdAndArtifactId;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.maven.tree.ResolvedPom;
import org.openrewrite.xml.tree.Xml;

public class GraalVmMigrationRecipe
extends Recipe {
    private static final String OPTAPLANNER_QUARKUS_MODULE = "optaplanner-quarkus";

    public String getDisplayName() {
        return "Migrate GraalVM SDK artifact";
    }

    public String getDescription() {
        return "Migrates 'org.graalvm.sdk:graal-sdk' to 'org.graalvm.nativeimage:svm'.";
    }

    protected MavenIsoVisitor<ExecutionContext> getSingleSourceApplicableTest() {
        return new MavenIsoVisitor<ExecutionContext>(){

            public Xml.Document visitDocument(Xml.Document document, ExecutionContext executionContext) {
                ResolvedPom pom = this.getResolutionResult().getPom();
                if (pom.getGroupId().equals("org.optaplanner") && pom.getArtifactId().startsWith(GraalVmMigrationRecipe.OPTAPLANNER_QUARKUS_MODULE)) {
                    return (Xml.Document)SearchResult.found((Tree)document);
                }
                return document;
            }
        };
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MavenIsoVisitor<ExecutionContext>(){

            public Xml.Document visitDocument(Xml.Document document, ExecutionContext executionContext) {
                GraalVmMigrationRecipe.this.doNext((Recipe)new ChangeDependencyGroupIdAndArtifactId("org.graalvm.sdk", "graal-sdk", "org.graalvm.nativeimage", "svm", null, null));
                return super.visitDocument(document, (Object)executionContext);
            }
        };
    }

    private boolean parentEndsWith(Path path, String suffix) {
        return path.getParent() != null && path.getParent().endsWith(suffix);
    }
}

