/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.migration.jakarta;

import java.util.Optional;
import java.util.function.BiConsumer;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.maven.ChangeDependencyGroupIdAndArtifactId;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.maven.RemoveExclusion;
import org.openrewrite.xml.tree.Xml;
import org.optaplanner.migration.jakarta.InternalOptaPlannerMavenVisitor;

public class JakartaHibernateMigrationRecipe
extends Recipe {
    private static final String HIBERNATE_GROUP_ID = "org.hibernate";
    private static final String HIBERNATE_ARTIFACT_ID = "hibernate-core";

    public String getDisplayName() {
        return "Migrate hibernate artifacts to Jakarta";
    }

    public String getDescription() {
        return "Migrates 'org.hibernate:hibernate-core' to 'org.hibernate:hibernate-core-jakarta'.";
    }

    protected MavenVisitor<ExecutionContext> getSingleSourceApplicableTest() {
        return new InternalOptaPlannerMavenVisitor();
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MavenIsoVisitor<ExecutionContext>(){

            public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext executionContext) {
                if (this.isDependencyTag(JakartaHibernateMigrationRecipe.HIBERNATE_GROUP_ID, JakartaHibernateMigrationRecipe.HIBERNATE_ARTIFACT_ID)) {
                    this.forEachExclusion(tag, (exclusionGroupId, exclusionArtifactId) -> JakartaHibernateMigrationRecipe.this.doNext((Recipe)new RemoveExclusion(JakartaHibernateMigrationRecipe.HIBERNATE_GROUP_ID, JakartaHibernateMigrationRecipe.HIBERNATE_ARTIFACT_ID, exclusionGroupId, exclusionArtifactId)));
                    JakartaHibernateMigrationRecipe.this.doNext((Recipe)new ChangeDependencyGroupIdAndArtifactId(JakartaHibernateMigrationRecipe.HIBERNATE_GROUP_ID, JakartaHibernateMigrationRecipe.HIBERNATE_ARTIFACT_ID, JakartaHibernateMigrationRecipe.HIBERNATE_GROUP_ID, "hibernate-core-jakarta", null, null));
                }
                return super.visitTag(tag, (Object)executionContext);
            }

            private void forEachExclusion(Xml.Tag tag, BiConsumer<String, String> exclusionConsumer) {
                tag.getChild("exclusions").ifPresent(exclusions -> exclusions.getChildren("exclusion").forEach(exclusion -> {
                    Optional exclusionGroupId = exclusion.getChildValue("groupId");
                    Optional exclusionArtifactId = exclusion.getChildValue("artifactId");
                    if (exclusionGroupId.isPresent() && exclusionArtifactId.isPresent()) {
                        exclusionConsumer.accept((String)exclusionGroupId.get(), (String)exclusionArtifactId.get());
                    }
                }));
            }
        };
    }
}

