/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.migration.v8;

import org.junit.jupiter.api.Test;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.java.Assertions;
import org.openrewrite.test.RecipeSpec;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpecs;
import org.optaplanner.migration.v8.ScoreManagerMethodsRecipe;

class ScoreManagerMethodsRecipeTest
implements RewriteTest {
    ScoreManagerMethodsRecipeTest() {
    }

    public void defaults(RecipeSpec spec) {
        spec.recipe((Recipe)new ScoreManagerMethodsRecipe()).parser((Parser.Builder)ScoreManagerMethodsRecipe.buildJavaParser());
    }

    @Test
    void summary() {
        this.runTest("String summary = scoreManager.getSummary(solution);", "String summary = scoreManager.explain(solution, SolutionUpdatePolicy.UPDATE_SCORE_ONLY).getSummary();");
    }

    @Test
    void explain() {
        this.runTest("ScoreExplanation explanation = scoreManager.explainScore(solution);", "ScoreExplanation explanation = scoreManager.explain(solution, SolutionUpdatePolicy.UPDATE_SCORE_ONLY);");
    }

    @Test
    void update() {
        this.runTest("Object score = scoreManager.updateScore(solution);", "Object score = scoreManager.update(solution, SolutionUpdatePolicy.UPDATE_SCORE_ONLY);");
    }

    private void runTest(String before, String after) {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)ScoreManagerMethodsRecipeTest.wrap(before, false), (String)ScoreManagerMethodsRecipeTest.wrap(after, true))});
    }

    private static String wrap(String content, boolean addImport) {
        return "import org.optaplanner.core.api.score.ScoreManager;\n" + (addImport ? "import org.optaplanner.core.api.solver.SolutionUpdatePolicy;\n" : "") + "import org.optaplanner.core.api.score.ScoreExplanation;\nimport org.optaplanner.core.api.solver.SolverFactory;\n\nclass Test {\n    public static void main(String[] args) {\n       SolverFactory solverFactory = SolverFactory.create(null);\n       ScoreManager scoreManager = ScoreManager.create(solverFactory);\n       Object solution = null;\n       " + content.trim() + "\n    }}\n";
    }
}

