/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.migration.jakarta;

import java.nio.file.Path;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.maven.ChangeDependencyGroupIdAndArtifactId;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.maven.RemoveDependency;
import org.openrewrite.maven.RemoveExclusion;
import org.openrewrite.xml.tree.Xml;
import org.optaplanner.migration.jakarta.InternalOptaPlannerMavenVisitor;

public class JakartaJsonMigrationRecipe
extends Recipe {
    private static final String OPTAPLANNER_JSONB_MODULE = "optaplanner-persistence-jsonb";
    private static final String ORG_GLASSFISH = "org.glassfish";
    private static final String ORG_ECLIPSE = "org.eclipse";
    private static final String JAKARTA_JSON = "jakarta.json";
    private static final String JAKARTA_JSON_API = "jakarta.json-api";
    private static final String YASSON = "yasson";

    public String getDisplayName() {
        return "Migrate Json artifacts to Jakarta";
    }

    public String getDescription() {
        return "Migrates 'org.glassfish:jakarta.json' to 'jakarta.json:jakarta.json-api'.";
    }

    protected MavenVisitor<ExecutionContext> getSingleSourceApplicableTest() {
        return new InternalOptaPlannerMavenVisitor();
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MavenIsoVisitor<ExecutionContext>(){

            public Xml.Document visitDocument(Xml.Document document, ExecutionContext executionContext) {
                Path parent = document.getSourcePath().getParent();
                if (parent != null && parent.toString().endsWith(JakartaJsonMigrationRecipe.OPTAPLANNER_JSONB_MODULE)) {
                    JakartaJsonMigrationRecipe.this.doNext((Recipe)new RemoveDependency(JakartaJsonMigrationRecipe.ORG_GLASSFISH, JakartaJsonMigrationRecipe.JAKARTA_JSON, "runtime"));
                    JakartaJsonMigrationRecipe.this.doNext((Recipe)new RemoveExclusion(JakartaJsonMigrationRecipe.ORG_ECLIPSE, JakartaJsonMigrationRecipe.YASSON, JakartaJsonMigrationRecipe.JAKARTA_JSON, JakartaJsonMigrationRecipe.JAKARTA_JSON_API, Boolean.valueOf(false)));
                    JakartaJsonMigrationRecipe.this.doNext((Recipe)new RemoveExclusion(JakartaJsonMigrationRecipe.ORG_ECLIPSE, JakartaJsonMigrationRecipe.YASSON, JakartaJsonMigrationRecipe.ORG_GLASSFISH, JakartaJsonMigrationRecipe.JAKARTA_JSON, Boolean.valueOf(false)));
                } else {
                    JakartaJsonMigrationRecipe.this.doNext((Recipe)new ChangeDependencyGroupIdAndArtifactId(JakartaJsonMigrationRecipe.ORG_GLASSFISH, JakartaJsonMigrationRecipe.JAKARTA_JSON, JakartaJsonMigrationRecipe.JAKARTA_JSON, JakartaJsonMigrationRecipe.JAKARTA_JSON_API, null, null));
                }
                return super.visitDocument(document, (Object)executionContext);
            }
        };
    }
}

