/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.operator.impl.solver;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.javaoperatorsdk.operator.api.reconciler.Context;
import io.javaoperatorsdk.operator.api.reconciler.ControllerConfiguration;
import io.javaoperatorsdk.operator.api.reconciler.ErrorStatusHandler;
import io.javaoperatorsdk.operator.api.reconciler.ErrorStatusUpdateControl;
import io.javaoperatorsdk.operator.api.reconciler.EventSourceContext;
import io.javaoperatorsdk.operator.api.reconciler.EventSourceInitializer;
import io.javaoperatorsdk.operator.api.reconciler.Reconciler;
import io.javaoperatorsdk.operator.api.reconciler.UpdateControl;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.KubernetesDependentResourceConfig;
import io.javaoperatorsdk.operator.processing.event.source.EventSource;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import org.optaplanner.operator.impl.solver.model.ConfigMapDependentResource;
import org.optaplanner.operator.impl.solver.model.DeploymentDependentResource;
import org.optaplanner.operator.impl.solver.model.OptaPlannerSolver;
import org.optaplanner.operator.impl.solver.model.OptaPlannerSolverSpec;
import org.optaplanner.operator.impl.solver.model.OptaPlannerSolverStatus;
import org.optaplanner.operator.impl.solver.model.keda.ScaledObjectDependentResource;
import org.optaplanner.operator.impl.solver.model.keda.TriggerAuthenticationDependentResource;
import org.optaplanner.operator.impl.solver.model.messaging.ArtemisQueue;
import org.optaplanner.operator.impl.solver.model.messaging.ArtemisQueueDependentResource;
import org.optaplanner.operator.impl.solver.model.messaging.ArtemisQueueSpec;
import org.optaplanner.operator.impl.solver.model.messaging.MessageAddress;

@ControllerConfiguration(name="optaplanner-solver")
public final class OptaPlannerSolverReconciler
implements Reconciler<OptaPlannerSolver>,
ErrorStatusHandler<OptaPlannerSolver>,
EventSourceInitializer<OptaPlannerSolver> {
    private KubernetesClient kubernetesClient;
    private final DeploymentDependentResource deploymentDependentResource;
    private final ArtemisQueueDependentResource inputQueueDependentResource;
    private final ArtemisQueueDependentResource outputQueueDependentResource;
    private final ConfigMapDependentResource configMapDependentResource;
    private final TriggerAuthenticationDependentResource triggerAuthenticationDependentResource;
    private final ScaledObjectDependentResource scaledObjectDependentResource;

    @Inject
    public OptaPlannerSolverReconciler(KubernetesClient kubernetesClient) {
        this.deploymentDependentResource = new DeploymentDependentResource(kubernetesClient);
        this.inputQueueDependentResource = new ArtemisQueueDependentResource(MessageAddress.INPUT, kubernetesClient);
        this.outputQueueDependentResource = new ArtemisQueueDependentResource(MessageAddress.OUTPUT, kubernetesClient);
        this.configMapDependentResource = new ConfigMapDependentResource(kubernetesClient);
        this.triggerAuthenticationDependentResource = new TriggerAuthenticationDependentResource(kubernetesClient);
        this.scaledObjectDependentResource = new ScaledObjectDependentResource(kubernetesClient);
        this.inputQueueDependentResource.configureWith(new KubernetesDependentResourceConfig().setLabelSelector(this.getQueueSelector(MessageAddress.INPUT)));
        this.outputQueueDependentResource.configureWith(new KubernetesDependentResourceConfig().setLabelSelector(this.getQueueSelector(MessageAddress.OUTPUT)));
    }

    private String getQueueSelector(MessageAddress messageAddress) {
        return "message-address=" + messageAddress.getName();
    }

    public Map<String, EventSource> prepareEventSources(EventSourceContext<OptaPlannerSolver> context) {
        return EventSourceInitializer.nameEventSources((EventSource[])new EventSource[]{this.deploymentDependentResource.initEventSource(context), this.inputQueueDependentResource.initEventSource(context), this.outputQueueDependentResource.initEventSource(context), this.configMapDependentResource.initEventSource(context), this.triggerAuthenticationDependentResource.initEventSource(context), this.scaledObjectDependentResource.initEventSource(context)});
    }

    public UpdateControl<OptaPlannerSolver> reconcile(OptaPlannerSolver solver, Context<OptaPlannerSolver> context) {
        boolean isReady = true;
        this.deploymentDependentResource.reconcile((HasMetadata)solver, context);
        this.inputQueueDependentResource.reconcile((HasMetadata)solver, context);
        this.outputQueueDependentResource.reconcile((HasMetadata)solver, context);
        if (((OptaPlannerSolverSpec)solver.getSpec()).getScaling().isDynamic()) {
            this.triggerAuthenticationDependentResource.reconcile((HasMetadata)solver, context);
            this.scaledObjectDependentResource.reconcile((HasMetadata)solver, context);
            if (this.scaledObjectDependentResource.getSecondaryResource((HasMetadata)solver).isEmpty() || this.triggerAuthenticationDependentResource.getSecondaryResource((HasMetadata)solver).isEmpty()) {
                isReady = false;
            }
        }
        Optional inputQueue = this.inputQueueDependentResource.getSecondaryResource((HasMetadata)solver);
        Optional outputQueue = this.outputQueueDependentResource.getSecondaryResource((HasMetadata)solver);
        if (inputQueue.isEmpty() || outputQueue.isEmpty()) {
            isReady = false;
        }
        if (inputQueue.isPresent() && outputQueue.isPresent()) {
            this.configMapDependentResource.reconcile((HasMetadata)solver, context);
            if (this.configMapDependentResource.getSecondaryResource((HasMetadata)solver).isEmpty()) {
                isReady = false;
            }
        }
        if (isReady) {
            solver.setStatus(OptaPlannerSolverStatus.ready(solver.getMetadata().getGeneration()));
            ((OptaPlannerSolverStatus)solver.getStatus()).setInputMessageAddress(((ArtemisQueueSpec)((ArtemisQueue)((Object)inputQueue.get())).getSpec()).getQueueName());
            ((OptaPlannerSolverStatus)solver.getStatus()).setOutputMessageAddress(((ArtemisQueueSpec)((ArtemisQueue)((Object)outputQueue.get())).getSpec()).getQueueName());
        } else {
            solver.setStatus(OptaPlannerSolverStatus.unknown(solver.getMetadata().getGeneration()));
        }
        return UpdateControl.updateStatus((HasMetadata)solver);
    }

    public ErrorStatusUpdateControl<OptaPlannerSolver> updateErrorStatus(OptaPlannerSolver solver, Context<OptaPlannerSolver> context, Exception e) {
        solver.setStatus(OptaPlannerSolverStatus.error(solver.getMetadata().getGeneration(), e));
        return ErrorStatusUpdateControl.updateStatus((HasMetadata)solver);
    }
}

