/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.operator.impl.solver.model.keda;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.quarkus.test.junit.QuarkusTest;
import org.optaplanner.operator.impl.solver.model.AbstractKubernetesCustomResourceTest;
import org.optaplanner.operator.impl.solver.model.common.ResourceNameReference;
import org.optaplanner.operator.impl.solver.model.keda.ScaledObject;
import org.optaplanner.operator.impl.solver.model.keda.ScaledObjectSpec;
import org.optaplanner.operator.impl.solver.model.keda.Trigger;
import org.optaplanner.operator.impl.solver.model.keda.TriggerMetadata;

@QuarkusTest
public class ScaledObjectTest
extends AbstractKubernetesCustomResourceTest<ScaledObject> {
    public ScaledObjectTest() {
        super(ScaledObject.class);
    }

    @Override
    protected ScaledObject createCustomResource() {
        TriggerMetadata triggerMetadata = new TriggerMetadata();
        triggerMetadata.setBrokerAddress("test-messaging-address");
        triggerMetadata.setBrokerName("amq-broker");
        triggerMetadata.setQueueLength(String.valueOf(1));
        triggerMetadata.setQueueName("test-messaging-queue");
        triggerMetadata.setManagementEndpoint("test-host:8161");
        Trigger trigger = new Trigger();
        trigger.setAuthenticationRef(new ResourceNameReference("test-trigger-auth"));
        trigger.setMetadata(triggerMetadata);
        trigger.setName("test-keda-trigger");
        trigger.setType("artemis-queue");
        ScaledObjectSpec scaledObjectSpec = new ScaledObjectSpec();
        scaledObjectSpec.setCooldownPeriod(10);
        scaledObjectSpec.setMaxReplicaCount(5);
        scaledObjectSpec.setMinReplicaCount(0);
        scaledObjectSpec.setPollingInterval(10);
        scaledObjectSpec.setScaleTargetRef(new ResourceNameReference("test-deployment"));
        scaledObjectSpec.withTrigger(trigger);
        ObjectMeta scaledObjectMeta = new ObjectMeta();
        scaledObjectMeta.setName("test-scaled-object");
        ScaledObject scaledObject = new ScaledObject();
        scaledObject.setMetadata(scaledObjectMeta);
        scaledObject.setSpec((Object)scaledObjectSpec);
        return scaledObject;
    }
}

