/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.operator.impl.solver.model;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapBuilder;
import io.fabric8.kubernetes.api.model.ConfigMapFluent;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.javaoperatorsdk.operator.api.reconciler.Context;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.CRUDKubernetesDependentResource;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.KubernetesDependent;
import java.util.HashMap;
import org.optaplanner.operator.impl.solver.model.OptaPlannerSolver;
import org.optaplanner.operator.impl.solver.model.OptaPlannerSolverSpec;

@KubernetesDependent
public final class ConfigMapDependentResource
extends CRUDKubernetesDependentResource<ConfigMap, OptaPlannerSolver> {
    public static final String SOLVER_MESSAGE_INPUT_KEY = "solver.message.input";
    public static final String SOLVER_MESSAGE_OUTPUT_KEY = "solver.message.output";
    public static final String SOLVER_MESSAGE_AMQ_HOST_KEY = "solver.amq.host";
    public static final String SOLVER_MESSAGE_AMQ_PORT_KEY = "solver.amq.port";

    public ConfigMapDependentResource(KubernetesClient kubernetesClient) {
        super(ConfigMap.class);
        this.setKubernetesClient(kubernetesClient);
    }

    protected ConfigMap desired(OptaPlannerSolver solver, Context<OptaPlannerSolver> context) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put(SOLVER_MESSAGE_INPUT_KEY, solver.getInputMessageAddressName());
        data.put(SOLVER_MESSAGE_OUTPUT_KEY, solver.getOutputMessageAddressName());
        data.put(SOLVER_MESSAGE_AMQ_HOST_KEY, ((OptaPlannerSolverSpec)solver.getSpec()).getAmqBroker().getHost());
        data.put(SOLVER_MESSAGE_AMQ_PORT_KEY, String.valueOf(((OptaPlannerSolverSpec)solver.getSpec()).getAmqBroker().getPort()));
        return ((ConfigMapBuilder)((ConfigMapBuilder)((ConfigMapFluent.MetadataNested)((ConfigMapFluent.MetadataNested)new ConfigMapBuilder().withNewMetadata().withName(solver.getConfigMapName())).withNamespace(solver.getNamespace())).endMetadata()).withData(data)).build();
    }

    public ConfigMap update(ConfigMap actual, ConfigMap target, OptaPlannerSolver solver, Context<OptaPlannerSolver> context) {
        ConfigMap resultingConfigMap = (ConfigMap)super.update((HasMetadata)actual, (HasMetadata)target, (HasMetadata)solver, context);
        String namespace = actual.getMetadata().getNamespace();
        ((FilterWatchListDeletable)((NonNamespaceOperation)this.getKubernetesClient().pods().inNamespace(namespace)).withLabel("app", solver.getMetadata().getName())).delete();
        return resultingConfigMap;
    }
}

