/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.operator.impl.solver.model.keda;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.javaoperatorsdk.operator.api.reconciler.Context;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.CRUDKubernetesDependentResource;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.KubernetesDependent;
import org.optaplanner.operator.impl.solver.model.AmqBroker;
import org.optaplanner.operator.impl.solver.model.OptaPlannerSolver;
import org.optaplanner.operator.impl.solver.model.OptaPlannerSolverSpec;
import org.optaplanner.operator.impl.solver.model.common.ResourceNameReference;
import org.optaplanner.operator.impl.solver.model.keda.ScaledObject;
import org.optaplanner.operator.impl.solver.model.keda.ScaledObjectSpec;
import org.optaplanner.operator.impl.solver.model.keda.Trigger;
import org.optaplanner.operator.impl.solver.model.keda.TriggerMetadata;

@KubernetesDependent
public final class ScaledObjectDependentResource
extends CRUDKubernetesDependentResource<ScaledObject, OptaPlannerSolver> {
    public static final String ARTEMIS_QUEUE_TRIGGER = "artemis-queue";
    private static final int MIN_REPLICAS = 0;
    private static final int POLLING_INTERVAL = 10;
    private static final int COOLDOWN_PERIOD = 10;
    private static final int TARGET_QUEUE_LENGTH = 1;

    public ScaledObjectDependentResource(KubernetesClient kubernetesClient) {
        super(ScaledObject.class);
        this.setKubernetesClient(kubernetesClient);
    }

    protected ScaledObject desired(OptaPlannerSolver optaPlannerSolver, Context<OptaPlannerSolver> context) {
        AmqBroker amqBroker = ((OptaPlannerSolverSpec)optaPlannerSolver.getSpec()).getAmqBroker();
        TriggerMetadata triggerMetadata = new TriggerMetadata();
        triggerMetadata.setBrokerAddress(optaPlannerSolver.getInputMessageAddressName());
        triggerMetadata.setQueueName(optaPlannerSolver.getInputMessageAddressName());
        triggerMetadata.setQueueLength(String.valueOf(1));
        triggerMetadata.setBrokerName(amqBroker.getBrokerName());
        triggerMetadata.setManagementEndpoint(amqBroker.getManagementEndpoint());
        Trigger trigger = new Trigger();
        trigger.setType(ARTEMIS_QUEUE_TRIGGER);
        trigger.setMetadata(triggerMetadata);
        trigger.setName(optaPlannerSolver.getScaledObjectTriggerName());
        trigger.setAuthenticationRef(new ResourceNameReference(optaPlannerSolver.getTriggerAuthenticationName()));
        ScaledObjectSpec spec = new ScaledObjectSpec();
        spec.withTrigger(trigger);
        spec.setScaleTargetRef(new ResourceNameReference(optaPlannerSolver.getDeploymentName()));
        spec.setMinReplicaCount(0);
        spec.setMaxReplicaCount(((OptaPlannerSolverSpec)optaPlannerSolver.getSpec()).getScaling().getReplicas());
        spec.setPollingInterval(10);
        spec.setCooldownPeriod(10);
        ScaledObject scaledObject = new ScaledObject();
        scaledObject.setSpec(spec);
        scaledObject.setMetadata(this.buildMetadata(optaPlannerSolver));
        scaledObject.setStatus(new ScaledObject.ScaledObjectStatus());
        return scaledObject;
    }

    private ObjectMeta buildMetadata(OptaPlannerSolver optaPlannerSolver) {
        return ((ObjectMetaBuilder)((ObjectMetaBuilder)new ObjectMetaBuilder().withName(optaPlannerSolver.getScaledObjectName())).withNamespace(optaPlannerSolver.getNamespace())).build();
    }
}

