/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.quarkus.devui;

import io.quarkus.arc.Arc;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.optaplanner.constraint.streams.common.AbstractConstraintStreamScoreDirectorFactory;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.solution.PlanningSolution;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.VariableDescriptor;
import org.optaplanner.core.impl.solver.DefaultSolverFactory;
import org.optaplanner.quarkus.devui.OptaPlannerDevUIProperties;
import org.optaplanner.quarkus.devui.OptaPlannerModelProperties;
import org.optaplanner.quarkus.devui.SolverConfigText;

@ApplicationScoped
public class OptaPlannerDevUIPropertiesRPCService {
    private final String effectiveSolverConfigXml;
    private OptaPlannerDevUIProperties devUIProperties;

    @Inject
    public OptaPlannerDevUIPropertiesRPCService(SolverConfigText solverConfigText) {
        this.effectiveSolverConfigXml = solverConfigText.getSolverConfigText();
    }

    @PostConstruct
    public void init() {
        this.devUIProperties = this.effectiveSolverConfigXml != null ? new OptaPlannerDevUIProperties(this.buildModelInfo(), this.buildXmlContentWithComment("Properties that can be set at runtime are not included"), this.buildConstraintList()) : new OptaPlannerDevUIProperties(this.buildModelInfo(), "<!-- Plugin execution was skipped because there are no @" + PlanningSolution.class.getSimpleName() + " or @" + PlanningEntity.class.getSimpleName() + " annotated classes. -->\n<solver />", Collections.emptyList());
    }

    public JsonObject getConfig() {
        JsonObject out = new JsonObject();
        out.put("config", (Object)this.devUIProperties.getEffectiveSolverConfig());
        return out;
    }

    public JsonArray getConstraints() {
        return JsonArray.of((Object[])this.devUIProperties.getConstraintList().toArray());
    }

    public JsonObject getModelInfo() {
        OptaPlannerModelProperties modelProperties = this.devUIProperties.getOptaPlannerModelProperties();
        JsonObject out = new JsonObject();
        out.put("solutionClass", (Object)modelProperties.solutionClass);
        out.put("entityClassList", (Object)JsonArray.of((Object[])modelProperties.entityClassList.toArray()));
        out.put("entityClassToGenuineVariableListMap", (Object)new JsonObject(modelProperties.entityClassToGenuineVariableListMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> JsonArray.of((Object[])((List)entry.getValue()).toArray())))));
        out.put("entityClassToShadowVariableListMap", (Object)new JsonObject(modelProperties.entityClassToShadowVariableListMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> JsonArray.of((Object[])((List)entry.getValue()).toArray())))));
        return out;
    }

    private OptaPlannerModelProperties buildModelInfo() {
        if (this.effectiveSolverConfigXml != null) {
            DefaultSolverFactory solverFactory = (DefaultSolverFactory)Arc.container().instance(SolverFactory.class, new Annotation[0]).get();
            SolutionDescriptor solutionDescriptor = solverFactory.getScoreDirectorFactory().getSolutionDescriptor();
            OptaPlannerModelProperties out = new OptaPlannerModelProperties();
            out.setSolutionClass(solutionDescriptor.getSolutionClass().getName());
            ArrayList<String> entityClassList = new ArrayList<String>();
            HashMap<String, List<String>> entityClassToGenuineVariableListMap = new HashMap<String, List<String>>();
            HashMap<String, List<String>> entityClassToShadowVariableListMap = new HashMap<String, List<String>>();
            for (EntityDescriptor entityDescriptor : solutionDescriptor.getEntityDescriptors()) {
                entityClassList.add(entityDescriptor.getEntityClass().getName());
                ArrayList<String> entityClassToGenuineVariableList = new ArrayList<String>();
                ArrayList<String> entityClassToShadowVariableList = new ArrayList<String>();
                for (VariableDescriptor variableDescriptor : entityDescriptor.getDeclaredVariableDescriptors()) {
                    if (variableDescriptor instanceof GenuineVariableDescriptor) {
                        entityClassToGenuineVariableList.add(variableDescriptor.getVariableName());
                        continue;
                    }
                    entityClassToShadowVariableList.add(variableDescriptor.getVariableName());
                }
                entityClassToGenuineVariableListMap.put(entityDescriptor.getEntityClass().getName(), entityClassToGenuineVariableList);
                entityClassToShadowVariableListMap.put(entityDescriptor.getEntityClass().getName(), entityClassToShadowVariableList);
            }
            out.setEntityClassList(entityClassList);
            out.setEntityClassToGenuineVariableListMap(entityClassToGenuineVariableListMap);
            out.setEntityClassToShadowVariableListMap(entityClassToShadowVariableListMap);
            return out;
        }
        return new OptaPlannerModelProperties();
    }

    private List<String> buildConstraintList() {
        DefaultSolverFactory solverFactory;
        if (this.effectiveSolverConfigXml != null && (solverFactory = (DefaultSolverFactory)Arc.container().instance(SolverFactory.class, new Annotation[0]).get()).getScoreDirectorFactory() instanceof AbstractConstraintStreamScoreDirectorFactory) {
            AbstractConstraintStreamScoreDirectorFactory scoreDirectorFactory = (AbstractConstraintStreamScoreDirectorFactory)solverFactory.getScoreDirectorFactory();
            return Arrays.stream(scoreDirectorFactory.getConstraints()).map(Constraint::getConstraintId).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private String buildXmlContentWithComment(String comment) {
        int indexOfPreambleEnd = this.effectiveSolverConfigXml.indexOf("?>");
        if (indexOfPreambleEnd != -1) {
            return this.effectiveSolverConfigXml.substring(0, indexOfPreambleEnd + 2) + "\n<!--" + comment + "-->\n" + this.effectiveSolverConfigXml.substring(indexOfPreambleEnd + 2);
        }
        return "<!--" + comment + "-->\n" + this.effectiveSolverConfigXml;
    }
}

