/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.quarkus.nativeimage;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.BiConsumer;
import java.util.function.Function;

@TargetClass(className="org.optaplanner.core.impl.domain.common.accessor.LambdaBeanPropertyMemberAccessor")
public final class Substitute_LambdaBeanPropertyMemberAccessor {
    @Alias
    Method getterMethod;
    @Alias
    Method setterMethod;

    @Substitute
    private Function<Object, Object> createGetterFunction(MethodHandles.Lookup lookup) {
        return new GetterDelegationFunction(this.getterMethod);
    }

    @Substitute
    private BiConsumer<Object, Object> createSetterFunction(MethodHandles.Lookup lookup) {
        if (this.setterMethod == null) {
            return null;
        }
        return new SetterDelegationBiConsumer(this.setterMethod);
    }

    private static final class GetterDelegationFunction
    implements Function<Object, Object> {
        private final Method method;

        public GetterDelegationFunction(Method method) {
            this.method = method;
        }

        @Override
        public Object apply(Object object) {
            try {
                return this.method.invoke(object, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static final class SetterDelegationBiConsumer
    implements BiConsumer<Object, Object> {
        private final Method method;

        public SetterDelegationBiConsumer(Method method) {
            this.method = method;
        }

        @Override
        public void accept(Object object, Object value) {
            try {
                this.method.invoke(object, value);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

