/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.quarkus.gizmo.annotations;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Type;
import org.optaplanner.quarkus.gizmo.annotations.AllOptaPlannerAnnotationEnum;

public class QuarkusRecordableAnnotations {
    public static Annotation getQuarkusRecorderFriendlyAnnotation(AnnotationInstance annotationInstance, IndexView indexView) {
        Class<?> annotationType;
        HashMap<String, Object> annotationValues = new HashMap<String, Object>();
        try {
            annotationType = Class.forName(annotationInstance.name().toString());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
        if (AllOptaPlannerAnnotationEnum.isOptaPlannerAnnotation(annotationType)) {
            annotationInstance.valuesWithDefaults(indexView).forEach(value -> annotationValues.put(value.name(), QuarkusRecordableAnnotations.getJavaObjectForJandexAnnotationValue(value, annotationInstance, indexView)));
            return AllOptaPlannerAnnotationEnum.getForClass(annotationType, annotationValues);
        }
        throw new IllegalStateException("The annotation (" + annotationType + ") is not an OptaPlanner annotation");
    }

    public static Object getJavaObjectForJandexAnnotationValue(AnnotationValue value, AnnotationInstance annotationInstance, IndexView indexView) {
        switch (value.kind()) {
            case BOOLEAN: {
                return value.asBoolean();
            }
            case BYTE: {
                return value.asByte();
            }
            case CHARACTER: {
                return Character.valueOf(value.asChar());
            }
            case SHORT: {
                return value.asShort();
            }
            case INTEGER: {
                return value.asInt();
            }
            case LONG: {
                return value.asLong();
            }
            case FLOAT: {
                return Float.valueOf(value.asFloat());
            }
            case DOUBLE: {
                return value.asDouble();
            }
            case STRING: {
                return value.asString();
            }
            case ENUM: {
                return value.asEnum();
            }
            case CLASS: {
                return QuarkusRecordableAnnotations.findClass(annotationInstance, value.asClass());
            }
            case NESTED: {
                return QuarkusRecordableAnnotations.getQuarkusRecorderFriendlyAnnotation(value.asNested(), indexView);
            }
            case ARRAY: {
                switch (value.componentKind()) {
                    case BOOLEAN: {
                        return value.asBooleanArray();
                    }
                    case BYTE: {
                        return value.asByteArray();
                    }
                    case CHARACTER: {
                        return value.asCharArray();
                    }
                    case SHORT: {
                        return value.asShortArray();
                    }
                    case INTEGER: {
                        return value.asIntArray();
                    }
                    case LONG: {
                        return value.asLongArray();
                    }
                    case FLOAT: {
                        return value.asFloatArray();
                    }
                    case DOUBLE: {
                        return value.asDoubleArray();
                    }
                    case STRING: {
                        return value.asStringArray();
                    }
                    case ENUM: {
                        return value.asEnumArray();
                    }
                    case CLASS: {
                        return Arrays.stream(value.asClassArray()).map(v -> QuarkusRecordableAnnotations.findClass(annotationInstance, v)).toArray(Class[]::new);
                    }
                    case NESTED: {
                        List annotationList = Arrays.stream(value.asNestedArray()).map(v -> QuarkusRecordableAnnotations.getQuarkusRecorderFriendlyAnnotation(v, indexView)).collect(Collectors.toList());
                        Class<? extends Annotation> annotationType = ((Annotation)annotationList.get(0)).annotationType();
                        Object out = Array.newInstance(annotationType, annotationList.size());
                        for (int i = 0; i < annotationList.size(); ++i) {
                            Array.set(out, i, annotationList.get(i));
                        }
                        return out;
                    }
                    case UNKNOWN: {
                        return new Object[0];
                    }
                }
                throw new IllegalStateException("Arrays of " + value.componentKind() + " are unsupported in the enum parser. This exception was caused by a @" + annotationInstance.name() + " annotation for parameter " + value.name() + ". Maybe put " + annotationInstance.name() + " not in a subpackage of org.optaplanner?");
            }
        }
        throw new IllegalStateException(value.componentKind() + " are unsupported in the enum parser. This exception was caused by a @" + annotationInstance.name() + " annotation for parameter " + value.name() + ". Maybe put " + annotationInstance.name() + " not in a subpackage of org.optaplanner?");
    }

    private static Class<?> findClass(AnnotationInstance annotationInstance, Type type) {
        try {
            return Class.forName(type.name().toString(), false, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Could not find class (" + type.name().toString() + ") referenced by annotation (" + annotationInstance.toString() + "). Maybe check your classpath?", e);
        }
    }

    private QuarkusRecordableAnnotations() {
    }
}

