/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.quarkus.gizmo.types;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jboss.jandex.IndexView;
import org.optaplanner.quarkus.gizmo.types.QuarkusRecordableClassType;
import org.optaplanner.quarkus.gizmo.types.QuarkusRecordableTypes;

public class QuarkusRecordableParameterizedType
implements ParameterizedType {
    String rawTypeName;
    Type ownerType;
    Type[] actualTypeArguments;

    public QuarkusRecordableParameterizedType() {
    }

    public QuarkusRecordableParameterizedType(org.jboss.jandex.ParameterizedType type, IndexView indexView) {
        this(type.name().toString(), QuarkusRecordableTypes.getQuarkusRecorderFriendlyType(type.owner(), indexView), (Type[])type.asParameterizedType().arguments().stream().map(argument -> QuarkusRecordableTypes.getQuarkusRecorderFriendlyType(argument, indexView)).toArray(Type[]::new));
    }

    public QuarkusRecordableParameterizedType(String rawTypeName, Type ownerType, Type[] actualTypeArguments) {
        this.rawTypeName = rawTypeName;
        this.ownerType = ownerType;
        this.actualTypeArguments = actualTypeArguments;
    }

    @Override
    public String getTypeName() {
        String prefix = "";
        if (this.ownerType != null) {
            prefix = this.ownerType.getTypeName() + ".";
        }
        return prefix + this.rawTypeName + "<" + Arrays.stream(this.actualTypeArguments).map(Type::getTypeName).collect(Collectors.joining(",")) + ">";
    }

    public String getRawTypeName() {
        return this.rawTypeName;
    }

    public void setRawTypeName(String rawTypeName) {
        this.rawTypeName = rawTypeName;
    }

    public String toString() {
        return this.getTypeName();
    }

    @Override
    public Type[] getActualTypeArguments() {
        return this.actualTypeArguments;
    }

    public void setActualTypeArguments(Type[] actualTypeArguments) {
        this.actualTypeArguments = actualTypeArguments;
    }

    @Override
    public Type getRawType() {
        return new QuarkusRecordableClassType(this.rawTypeName);
    }

    @Override
    public Type getOwnerType() {
        return this.ownerType;
    }

    public void setOwnerType(Type ownerType) {
        this.ownerType = ownerType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QuarkusRecordableParameterizedType that = (QuarkusRecordableParameterizedType)o;
        return this.rawTypeName.equals(that.rawTypeName) && Objects.equals(this.ownerType, that.ownerType) && Arrays.equals(this.actualTypeArguments, that.actualTypeArguments);
    }

    public int hashCode() {
        int result = Objects.hash(this.rawTypeName, this.ownerType);
        result = 31 * result + Arrays.hashCode(this.actualTypeArguments);
        return result;
    }
}

