/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.quarkus.gizmo.types;

import org.jboss.jandex.IndexView;
import org.jboss.jandex.PrimitiveType;
import org.jboss.jandex.Type;
import org.optaplanner.quarkus.gizmo.types.QuarkusRecordableArrayType;
import org.optaplanner.quarkus.gizmo.types.QuarkusRecordableParameterizedType;
import org.optaplanner.quarkus.gizmo.types.QuarkusRecordableTypeVariable;
import org.optaplanner.quarkus.gizmo.types.QuarkusRecordableWildcardType;

public class QuarkusRecordableTypes {
    public static java.lang.reflect.Type getQuarkusRecorderFriendlyType(Type jandexType, IndexView indexView) {
        if (jandexType == null) {
            return null;
        }
        switch (jandexType.kind()) {
            case CLASS: {
                try {
                    return Class.forName(jandexType.asClassType().name().toString(), false, Thread.currentThread().getContextClassLoader());
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException("Unable to find class (" + jandexType.asClassType().name() + "). Maybe check your classpath?", e);
                }
            }
            case ARRAY: {
                return new QuarkusRecordableArrayType(QuarkusRecordableTypes.getQuarkusRecorderFriendlyType(jandexType.asArrayType().component(), indexView));
            }
            case PRIMITIVE: {
                return QuarkusRecordableTypes.lookupPrimitiveType(jandexType.asPrimitiveType().primitive());
            }
            case VOID: {
                return Void.TYPE;
            }
            case TYPE_VARIABLE: {
                return new QuarkusRecordableTypeVariable(jandexType.asTypeVariable(), indexView);
            }
            case UNRESOLVED_TYPE_VARIABLE: {
                return new QuarkusRecordableTypeVariable(jandexType.asUnresolvedTypeVariable(), indexView);
            }
            case WILDCARD_TYPE: {
                return new QuarkusRecordableWildcardType(jandexType.asWildcardType(), indexView);
            }
            case PARAMETERIZED_TYPE: {
                return new QuarkusRecordableParameterizedType(jandexType.asParameterizedType(), indexView);
            }
        }
        throw new IllegalArgumentException("Unhandled case (" + jandexType.kind() + ").");
    }

    private static java.lang.reflect.Type lookupPrimitiveType(PrimitiveType.Primitive primitive) {
        switch (primitive) {
            case BYTE: {
                return Byte.TYPE;
            }
            case CHAR: {
                return Character.TYPE;
            }
            case DOUBLE: {
                return Double.TYPE;
            }
            case FLOAT: {
                return Float.TYPE;
            }
            case INT: {
                return Integer.TYPE;
            }
            case LONG: {
                return Long.TYPE;
            }
            case SHORT: {
                return Short.TYPE;
            }
            case BOOLEAN: {
                return Boolean.TYPE;
            }
        }
        throw new IllegalStateException();
    }

    private QuarkusRecordableTypes() {
    }
}

