/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.quarkus.nativeimage;

import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import org.optaplanner.core.impl.domain.common.ReflectionHelper;
import org.optaplanner.core.impl.domain.common.accessor.MemberAccessor;
import org.optaplanner.core.impl.domain.common.accessor.MemberAccessorFactory;
import org.optaplanner.core.impl.domain.common.accessor.ReflectionBeanPropertyMemberAccessor;
import org.optaplanner.core.impl.domain.common.accessor.ReflectionFieldMemberAccessor;
import org.optaplanner.core.impl.domain.common.accessor.ReflectionMethodMemberAccessor;

@TargetClass(className="org.optaplanner.core.impl.domain.common.accessor.MemberAccessorFactory")
public final class Substitute_MemberAccessorFactory {
    @Substitute
    private static MemberAccessor buildReflectiveMemberAccessor(Member member, MemberAccessorFactory.MemberAccessorType memberAccessorType, Class<? extends Annotation> annotationClass) {
        if (member instanceof Field) {
            Field field = (Field)member;
            return new ReflectionFieldMemberAccessor(field);
        }
        if (member instanceof Method) {
            ReflectionMethodMemberAccessor memberAccessor;
            Method method = (Method)member;
            switch (memberAccessorType) {
                case FIELD_OR_READ_METHOD: {
                    if (!ReflectionHelper.isGetterMethod((Method)method)) {
                        ReflectionHelper.assertReadMethod((Method)method, annotationClass);
                        memberAccessor = new ReflectionMethodMemberAccessor(method);
                        break;
                    }
                }
                case FIELD_OR_GETTER_METHOD: 
                case FIELD_OR_GETTER_METHOD_WITH_SETTER: {
                    boolean getterOnly = memberAccessorType != MemberAccessorFactory.MemberAccessorType.FIELD_OR_GETTER_METHOD_WITH_SETTER;
                    ReflectionHelper.assertGetterMethod((Method)method, annotationClass);
                    memberAccessor = new ReflectionBeanPropertyMemberAccessor(method, getterOnly);
                    break;
                }
                default: {
                    throw new IllegalStateException("The memberAccessorType (" + memberAccessorType + ") is not implemented.");
                }
            }
            if (memberAccessorType == MemberAccessorFactory.MemberAccessorType.FIELD_OR_GETTER_METHOD_WITH_SETTER && !memberAccessor.supportSetter()) {
                throw new IllegalStateException("The class (" + method.getDeclaringClass() + ") has a @" + annotationClass.getSimpleName() + " annotated getter method (" + method + "), but lacks a setter for that property (" + memberAccessor.getName() + ").");
            }
            return memberAccessor;
        }
        throw new IllegalStateException("Impossible state: the member (" + member + ")'s type is not a " + Field.class.getSimpleName() + " or a " + Method.class.getSimpleName() + ".");
    }
}

