/*
 * Decompiled with CFR 0.152.
 */
package org.optsol.jmip.linearsolver.model;

import com.google.ortools.Loader;
import com.google.ortools.linearsolver.MPSolutionResponse;
import com.google.ortools.linearsolver.MPSolver;
import com.google.ortools.linearsolver.MPSolverParameters;
import com.google.ortools.linearsolver.MPVariable;
import java.time.Duration;
import java.time.LocalDateTime;
import org.optsol.jmip.core.model.AbstractModel;
import org.optsol.jmip.core.model.constants.IConstants;
import org.optsol.jmip.core.solver.solution.SolutionState;
import org.optsol.jmip.linearsolver.solver.solution.LinearSolutionStateMapper;

public abstract class LinearModel<CONSTANTS extends IConstants>
extends AbstractModel<MPSolver, MPVariable, CONSTANTS> {
    private MPSolver.ResultStatus resultStatus = MPSolver.ResultStatus.NOT_SOLVED;
    private MPSolutionResponse solutionResponse = null;
    private Duration solutionDuration = null;

    public boolean solve(MPSolverParameters solverParams) {
        this.resultStatus = MPSolver.ResultStatus.NOT_SOLVED;
        this.solutionResponse = null;
        this.solutionDuration = null;
        LocalDateTime startTime = LocalDateTime.now();
        this.resultStatus = ((MPSolver)this.getSolver()).solve(solverParams);
        this.solutionDuration = Duration.between(startTime, LocalDateTime.now());
        this.solutionResponse = ((MPSolver)this.getSolver()).createSolutionResponseProto();
        return this.resultStatus == MPSolver.ResultStatus.OPTIMAL;
    }

    public Double getObjectiveValue() throws Exception {
        if (this.solutionResponse != null && this.solutionResponse.hasObjectiveValue()) {
            return this.solutionResponse.getObjectiveValue();
        }
        return null;
    }

    public SolutionState getSolutionState() throws Exception {
        return LinearSolutionStateMapper.convert(this.resultStatus);
    }

    public Double getBestObjectiveBound() throws Exception {
        if (this.solutionResponse != null && this.solutionResponse.hasBestObjectiveBound()) {
            return this.solutionResponse.getBestObjectiveBound();
        }
        return null;
    }

    public Duration getSolutionTime() throws Exception {
        return this.solutionDuration;
    }

    static {
        Loader.loadNativeLibraries();
    }
}

