/*
 * Decompiled with CFR 0.152.
 */
package org.optsol.jmip.linearsolver.model.variables;

import com.google.ortools.linearsolver.MPSolver;
import com.google.ortools.linearsolver.MPVariable;
import java.util.List;
import org.optsol.jmip.core.model.constants.IConstants;
import org.optsol.jmip.core.model.variables.AbstractVariable;

public class LinearVariable<CONSTANTS extends IConstants>
extends AbstractVariable<MPSolver, MPVariable, CONSTANTS> {
    private List<Double> variableValueList = null;
    private List<Double> variableReducedCostList = null;

    private LinearVariable(AbstractVariable.AbstractBuilder<MPSolver, MPVariable, CONSTANTS> builder) {
        super(builder);
    }

    protected MPVariable createIntVar(AbstractVariable.VarKey varKey, MPSolver solver, Double upperBound, Double lowerBound) {
        if (upperBound == null) {
            upperBound = Double.POSITIVE_INFINITY;
        }
        if (lowerBound == null) {
            lowerBound = Double.NEGATIVE_INFINITY;
        }
        return solver.makeIntVar(lowerBound.doubleValue(), upperBound.doubleValue(), varKey.toString());
    }

    protected MPVariable createNumVar(AbstractVariable.VarKey varKey, MPSolver solver, Double upperBound, Double lowerBound) {
        if (upperBound == null) {
            upperBound = Double.POSITIVE_INFINITY;
        }
        if (lowerBound == null) {
            lowerBound = Double.NEGATIVE_INFINITY;
        }
        return solver.makeNumVar(lowerBound.doubleValue(), upperBound.doubleValue(), varKey.toString());
    }

    protected void updateBoundsOfVar(MPVariable var, MPSolver mpSolver, Double upperBound, Double lowerBound) throws Exception {
        if (upperBound == null) {
            upperBound = Double.POSITIVE_INFINITY;
        }
        if (lowerBound == null) {
            lowerBound = Double.NEGATIVE_INFINITY;
        }
        var.setBounds(lowerBound.doubleValue(), upperBound.doubleValue());
    }

    protected double getValueOfVar(MPSolver solver, MPVariable var) {
        if (this.variableValueList == null) {
            this.variableValueList = solver.createSolutionResponseProto().getVariableValueList();
        }
        return this.variableValueList.get(var.index());
    }

    protected double getReducedCostOfVar(MPSolver solver, MPVariable var) {
        if (this.variableReducedCostList == null) {
            this.variableReducedCostList = solver.createSolutionResponseProto().getReducedCostList();
        }
        return this.variableReducedCostList.get(var.index());
    }

    public static class Builder<CONSTANTS extends IConstants>
    extends AbstractVariable.AbstractBuilder<MPSolver, MPVariable, CONSTANTS> {
        public AbstractVariable<MPSolver, MPVariable, CONSTANTS> build() {
            return new LinearVariable(this);
        }
    }
}

