/*
 * Decompiled with CFR 0.152.
 */
package org.optsol.jmip.linearsolver.solver;

import com.google.ortools.Loader;
import com.google.ortools.linearsolver.MPSolver;
import com.google.ortools.linearsolver.MPSolverParameters;
import com.google.ortools.linearsolver.MPVariable;
import java.time.Duration;
import java.util.Objects;
import lombok.Generated;
import org.optsol.jmip.core.model.constants.IConstants;
import org.optsol.jmip.core.solver.Solver;
import org.optsol.jmip.core.solver.solution.ISolution;
import org.optsol.jmip.core.solver.solution.ISolutionExtractor;
import org.optsol.jmip.linearsolver.model.LinearModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LinearSolver<CONSTANTS extends IConstants, SOLUTION extends ISolution, MODEL extends LinearModel<CONSTANTS>>
extends Solver<CONSTANTS, MPSolver, MPVariable, MODEL, SOLUTION> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LinearSolver.class);
    private final MPSolver.OptimizationProblemType solverEngineType;
    private final Duration timeLimit;
    private final boolean enableOutput;
    private final boolean suppressOutput;
    private final String solverSpecificParameters;
    private final MPSolverParameters solverParameters;
    private final Double dualTolerance;
    private final Double primalTolerance;
    private final Double relativeMipGap;
    private final MPSolverParameters.IncrementalityValues incrementality;
    private final MPSolverParameters.LpAlgorithmValues lpAlgorithm;
    private final MPSolverParameters.PresolveValues presolve;
    private final MPSolverParameters.ScalingValues scaling;

    public LinearSolver(Class<MODEL> modelClass, ISolutionExtractor<SOLUTION, MODEL> solutionExtractor, MPSolver.OptimizationProblemType solverEngineType, Duration timeLimit, boolean enableOutput, boolean suppressOutput, String solverSpecificParameters, MPSolverParameters solverParameters, Double dualTolerance, Double primalTolerance, Double relativeMipGap, MPSolverParameters.IncrementalityValues incrementality, MPSolverParameters.LpAlgorithmValues lpAlgorithm, MPSolverParameters.PresolveValues presolve, MPSolverParameters.ScalingValues scaling) {
        super(modelClass, solutionExtractor);
        this.solverEngineType = Objects.requireNonNullElse(solverEngineType, MPSolver.OptimizationProblemType.SCIP_MIXED_INTEGER_PROGRAMMING);
        this.timeLimit = timeLimit;
        this.enableOutput = enableOutput;
        this.suppressOutput = suppressOutput;
        this.solverSpecificParameters = solverSpecificParameters;
        this.solverParameters = solverParameters;
        this.dualTolerance = dualTolerance;
        this.primalTolerance = primalTolerance;
        this.relativeMipGap = relativeMipGap;
        this.incrementality = incrementality;
        this.lpAlgorithm = lpAlgorithm;
        this.presolve = presolve;
        this.scaling = scaling;
    }

    public LinearSolver(Class<MODEL> modelClass, Class<SOLUTION> solutionInterface, MPSolver.OptimizationProblemType solverEngineType, Duration timeLimit, boolean enableOutput, boolean suppressOutput, String solverSpecificParameters, MPSolverParameters solverParameters, Double dualTolerance, Double primalTolerance, Double relativeMipGap, MPSolverParameters.IncrementalityValues incrementality, MPSolverParameters.LpAlgorithmValues lpAlgorithm, MPSolverParameters.PresolveValues presolve, MPSolverParameters.ScalingValues scaling) {
        super(modelClass, solutionInterface);
        this.solverEngineType = Objects.requireNonNullElse(solverEngineType, MPSolver.OptimizationProblemType.SCIP_MIXED_INTEGER_PROGRAMMING);
        this.timeLimit = timeLimit;
        this.enableOutput = enableOutput;
        this.suppressOutput = suppressOutput;
        this.solverSpecificParameters = solverSpecificParameters;
        this.solverParameters = solverParameters;
        this.dualTolerance = dualTolerance;
        this.primalTolerance = primalTolerance;
        this.relativeMipGap = relativeMipGap;
        this.incrementality = incrementality;
        this.lpAlgorithm = lpAlgorithm;
        this.presolve = presolve;
        this.scaling = scaling;
    }

    public static <CONSTANTS extends IConstants, SOLUTION extends ISolution, MODEL extends LinearModel<CONSTANTS>> LinearSolverBuilder<CONSTANTS, SOLUTION, MODEL> builder(Class<MODEL> modelClass, ISolutionExtractor<SOLUTION, MODEL> solutionExtractor) {
        return new LinearSolverBuilder(modelClass, solutionExtractor);
    }

    public static <CONSTANTS extends IConstants, SOLUTION extends ISolution, MODEL extends LinearModel<CONSTANTS>> LinearSolverBuilder<CONSTANTS, SOLUTION, MODEL> builder(Class<MODEL> modelClass, Class<SOLUTION> solutionInterface) {
        return new LinearSolverBuilder(modelClass, solutionInterface);
    }

    protected MPSolver generateSolverEngine() {
        return this.setTimeLimit(this.setEnableOutput(this.setSupressOutput(this.setSolverSpecificParameters(MPSolver.createSolver((String)this.solverEngineType.name())))));
    }

    protected void solve(MODEL model) {
        ((LinearModel)((Object)model)).solve(this.generateSolverParameters());
    }

    private MPSolverParameters generateSolverParameters() {
        MPSolverParameters mpSolverParameters = this.solverParameters;
        if (mpSolverParameters == null) {
            mpSolverParameters = new MPSolverParameters();
        }
        return this.setDualTolerance(this.setPrimalTolerance(this.setRelativeMipGap(this.setIncrementality(this.setLpAlgorithm(this.setPresolve(this.setScaling(mpSolverParameters)))))));
    }

    private MPSolverParameters setDualTolerance(MPSolverParameters mpSolverParameters) {
        if (this.dualTolerance != null) {
            mpSolverParameters.setDoubleParam(MPSolverParameters.DoubleParam.DUAL_TOLERANCE, this.dualTolerance.doubleValue());
        }
        return mpSolverParameters;
    }

    private MPSolverParameters setPrimalTolerance(MPSolverParameters mpSolverParameters) {
        if (this.primalTolerance != null) {
            mpSolverParameters.setDoubleParam(MPSolverParameters.DoubleParam.PRIMAL_TOLERANCE, this.primalTolerance.doubleValue());
        }
        return mpSolverParameters;
    }

    private MPSolverParameters setRelativeMipGap(MPSolverParameters mpSolverParameters) {
        if (this.relativeMipGap != null) {
            mpSolverParameters.setDoubleParam(MPSolverParameters.DoubleParam.RELATIVE_MIP_GAP, this.relativeMipGap.doubleValue());
        }
        return mpSolverParameters;
    }

    private MPSolverParameters setIncrementality(MPSolverParameters mpSolverParameters) {
        if (this.incrementality != null) {
            mpSolverParameters.setIntegerParam(MPSolverParameters.IntegerParam.INCREMENTALITY, this.incrementality.swigValue());
        }
        return mpSolverParameters;
    }

    private MPSolverParameters setLpAlgorithm(MPSolverParameters mpSolverParameters) {
        if (this.lpAlgorithm != null) {
            mpSolverParameters.setIntegerParam(MPSolverParameters.IntegerParam.LP_ALGORITHM, this.lpAlgorithm.swigValue());
        }
        return mpSolverParameters;
    }

    private MPSolverParameters setPresolve(MPSolverParameters mpSolverParameters) {
        if (this.presolve != null) {
            mpSolverParameters.setIntegerParam(MPSolverParameters.IntegerParam.PRESOLVE, this.presolve.swigValue());
        }
        return mpSolverParameters;
    }

    private MPSolverParameters setScaling(MPSolverParameters mpSolverParameters) {
        if (this.scaling != null) {
            mpSolverParameters.setIntegerParam(MPSolverParameters.IntegerParam.SCALING, this.scaling.swigValue());
        }
        return mpSolverParameters;
    }

    private MPSolver setSolver(MPSolver mpSolver) {
        if (this.timeLimit != null) {
            mpSolver.setTimeLimit(this.timeLimit.toMillis());
        }
        return mpSolver;
    }

    private MPSolver setTimeLimit(MPSolver mpSolver) {
        if (this.timeLimit != null) {
            mpSolver.setTimeLimit(this.timeLimit.toMillis());
        }
        return mpSolver;
    }

    private MPSolver setEnableOutput(MPSolver mpSolver) {
        if (this.enableOutput) {
            mpSolver.enableOutput();
        }
        return mpSolver;
    }

    private MPSolver setSupressOutput(MPSolver mpSolver) {
        if (this.suppressOutput) {
            mpSolver.suppressOutput();
        }
        return mpSolver;
    }

    private MPSolver setSolverSpecificParameters(MPSolver mpSolver) {
        if (this.solverSpecificParameters != null) {
            mpSolver.setSolverSpecificParametersAsString(this.solverSpecificParameters);
        }
        return mpSolver;
    }

    static {
        Loader.loadNativeLibraries();
    }

    public static class LinearSolverBuilder<CONSTANTS extends IConstants, SOLUTION extends ISolution, MODEL extends LinearModel<CONSTANTS>> {
        private final Class<MODEL> modelClass;
        private final ISolutionExtractor<SOLUTION, MODEL> solutionExtractor;
        private final Class<SOLUTION> solutionInterface;
        private MPSolver.OptimizationProblemType solverEngineType;
        private Duration timeLimit;
        private Boolean enableOutput;
        private Boolean suppressOutput;
        private String solverSpecificParameters;
        private MPSolverParameters solverParameters;
        private Double dualTolerance;
        private Double primalTolerance;
        private Double relativeMipGap;
        private MPSolverParameters.IncrementalityValues incrementality;
        private MPSolverParameters.LpAlgorithmValues lpAlgorithm;
        private MPSolverParameters.PresolveValues presolve;
        private MPSolverParameters.ScalingValues scaling;

        LinearSolverBuilder(Class<MODEL> modelClass, ISolutionExtractor<SOLUTION, MODEL> solutionExtractor) {
            this.modelClass = modelClass;
            this.solutionExtractor = solutionExtractor;
            this.solutionInterface = null;
        }

        LinearSolverBuilder(Class<MODEL> modelClass, Class<SOLUTION> solutionInterface) {
            this.modelClass = modelClass;
            this.solutionExtractor = null;
            this.solutionInterface = solutionInterface;
        }

        public LinearSolverBuilder<CONSTANTS, SOLUTION, MODEL> solverEngineType(MPSolver.OptimizationProblemType solverEngineType) {
            this.solverEngineType = solverEngineType;
            return this;
        }

        public LinearSolverBuilder<CONSTANTS, SOLUTION, MODEL> timeLimit(Duration timeLimit) {
            this.timeLimit = timeLimit;
            return this;
        }

        public LinearSolverBuilder<CONSTANTS, SOLUTION, MODEL> enableOutput() {
            this.enableOutput = true;
            return this;
        }

        public LinearSolverBuilder<CONSTANTS, SOLUTION, MODEL> suppressOutput() {
            this.suppressOutput = true;
            return this;
        }

        public LinearSolverBuilder<CONSTANTS, SOLUTION, MODEL> solverSpecificParameters(String solverSpecificParameters) {
            this.solverSpecificParameters = solverSpecificParameters;
            return this;
        }

        public LinearSolverBuilder<CONSTANTS, SOLUTION, MODEL> solverParameters(MPSolverParameters solverParameters) {
            this.solverParameters = solverParameters;
            return this;
        }

        public LinearSolverBuilder<CONSTANTS, SOLUTION, MODEL> dualTolerance(double dualTolerance) {
            this.dualTolerance = dualTolerance;
            return this;
        }

        public LinearSolverBuilder<CONSTANTS, SOLUTION, MODEL> primalTolerance(double primalTolerance) {
            this.primalTolerance = primalTolerance;
            return this;
        }

        public LinearSolverBuilder<CONSTANTS, SOLUTION, MODEL> relativeMipGap(double relativeMipGap) {
            this.relativeMipGap = relativeMipGap;
            return this;
        }

        public LinearSolverBuilder<CONSTANTS, SOLUTION, MODEL> incrementalityOn() {
            this.incrementality = MPSolverParameters.IncrementalityValues.INCREMENTALITY_ON;
            return this;
        }

        public LinearSolverBuilder<CONSTANTS, SOLUTION, MODEL> incrementalityOff() {
            this.incrementality = MPSolverParameters.IncrementalityValues.INCREMENTALITY_OFF;
            return this;
        }

        public LinearSolverBuilder<CONSTANTS, SOLUTION, MODEL> lpAlgorithm_Barrier() {
            this.lpAlgorithm = MPSolverParameters.LpAlgorithmValues.BARRIER;
            return this;
        }

        public LinearSolverBuilder<CONSTANTS, SOLUTION, MODEL> lpAlgorithm_Dual() {
            this.lpAlgorithm = MPSolverParameters.LpAlgorithmValues.DUAL;
            return this;
        }

        public LinearSolverBuilder<CONSTANTS, SOLUTION, MODEL> lpAlgorithm_Primal() {
            this.lpAlgorithm = MPSolverParameters.LpAlgorithmValues.PRIMAL;
            return this;
        }

        public LinearSolverBuilder<CONSTANTS, SOLUTION, MODEL> presolveOn() {
            this.presolve = MPSolverParameters.PresolveValues.PRESOLVE_ON;
            return this;
        }

        public LinearSolverBuilder<CONSTANTS, SOLUTION, MODEL> presolveOff() {
            this.presolve = MPSolverParameters.PresolveValues.PRESOLVE_OFF;
            return this;
        }

        public LinearSolverBuilder<CONSTANTS, SOLUTION, MODEL> scalingOn() {
            this.scaling = MPSolverParameters.ScalingValues.SCALING_ON;
            return this;
        }

        public LinearSolverBuilder<CONSTANTS, SOLUTION, MODEL> scalingOff() {
            this.scaling = MPSolverParameters.ScalingValues.SCALING_OFF;
            return this;
        }

        public LinearSolver<CONSTANTS, SOLUTION, MODEL> build() {
            if (this.solutionExtractor != null) {
                return new LinearSolver(this.modelClass, this.solutionExtractor, this.solverEngineType, this.timeLimit, Boolean.TRUE.equals(this.enableOutput), Boolean.TRUE.equals(this.suppressOutput), this.solverSpecificParameters, this.solverParameters, this.dualTolerance, this.primalTolerance, this.relativeMipGap, this.incrementality, this.lpAlgorithm, this.presolve, this.scaling);
            }
            return new LinearSolver(this.modelClass, this.solutionInterface, this.solverEngineType, this.timeLimit, Boolean.TRUE.equals(this.enableOutput), Boolean.TRUE.equals(this.suppressOutput), this.solverSpecificParameters, this.solverParameters, this.dualTolerance, this.primalTolerance, this.relativeMipGap, this.incrementality, this.lpAlgorithm, this.presolve, this.scaling);
        }
    }
}

