/*
 * Decompiled with CFR 0.152.
 */
package org.orangepalantir.leastsquares.fitters;

import Jama.Matrix;
import org.orangepalantir.leastsquares.Fitter;
import org.orangepalantir.leastsquares.Function;

public class LinearFitter
implements Fitter {
    private final double[] working;
    double[][] X;
    double[] A;
    double[] Z;
    Function FUNCTION;
    double[] ERROR;
    double[][] DERIVATIVES;
    double[] BETA;
    double[][] ALPHA;
    double DELTA = 1.0E-6;

    public LinearFitter(Function funct) {
        this.FUNCTION = funct;
        this.working = new double[funct.getNParameters()];
    }

    @Override
    public void setData(double[][] xvalues, double[] zvalues) {
        if (xvalues.length != zvalues.length) {
            throw new IllegalArgumentException("there must be 1 z value for each set of x values");
        }
        if (xvalues[0].length != this.FUNCTION.getNInputs()) {
            throw new IllegalArgumentException("The length of parameters is longer that the parameters accepted by the function");
        }
        this.X = xvalues;
        this.Z = zvalues;
    }

    @Override
    public void setParameters(double[] parameters) {
        if (parameters.length != this.FUNCTION.getNParameters()) {
            throw new IllegalArgumentException("the number of parameters must equal the required number for the function: " + this.FUNCTION.getNParameters());
        }
        this.A = new double[parameters.length];
        System.arraycopy(parameters, 0, this.A, 0, parameters.length);
    }

    @Override
    public double calculateErrors() {
        double new_error = 0.0;
        for (int i = 0; i < this.Z.length; ++i) {
            double v = this.FUNCTION.evaluate(this.X[i], this.A);
            this.ERROR[i] = this.Z[i] - v;
            new_error += Math.pow(this.ERROR[i], 2.0);
        }
        return new_error;
    }

    public double calculateDerivative(int k, double[] x) {
        for (int i = 0; i < this.FUNCTION.getNParameters(); ++i) {
            this.working[i] = i == k ? 1.0 : 0.0;
        }
        return this.FUNCTION.evaluate(x, this.working);
    }

    public void calculateDerivatives() {
        for (int j = 0; j < this.A.length; ++j) {
            for (int i = 0; i < this.Z.length; ++i) {
                this.DERIVATIVES[i][j] = this.calculateDerivative(j, this.X[i]);
            }
        }
    }

    public void createBetaMatrix() {
        this.BETA = new double[this.A.length];
        for (int k = 0; k < this.BETA.length; ++k) {
            for (int i = 0; i < this.X.length; ++i) {
                int n = k;
                this.BETA[n] = this.BETA[n] + this.ERROR[i] * this.DERIVATIVES[i][k];
            }
        }
    }

    public void createAlphaMatrix() {
        this.ALPHA = new double[this.A.length][this.A.length];
        int n = this.A.length;
        for (int k = 0; k < n; ++k) {
            for (int l = 0; l < n; ++l) {
                for (int i = 0; i < this.X.length; ++i) {
                    double[] dArray = this.ALPHA[l];
                    int n2 = k;
                    dArray[n2] = dArray[n2] + this.DERIVATIVES[i][k] * this.DERIVATIVES[i][l];
                }
            }
        }
    }

    public void iterateValues() {
        this.calculateErrors();
        this.calculateDerivatives();
        this.createBetaMatrix();
        this.createAlphaMatrix();
        Matrix alpha_matrix = new Matrix(this.ALPHA);
        Matrix beta = new Matrix(this.BETA, this.BETA.length);
        Matrix out = alpha_matrix.solve(beta);
        double[][] delta_a = out.getArray();
        for (int i = 0; i < this.A.length; ++i) {
            int n = i;
            this.A[n] = this.A[n] + delta_a[i][0];
        }
    }

    public void printMatrix() {
        for (int i = 0; i < this.ALPHA.length; ++i) {
            for (int j = 0; j < this.ALPHA[0].length; ++j) {
                System.out.print(this.ALPHA[i][j] + "\t");
            }
            System.out.println("| " + this.BETA[i]);
        }
    }

    public void initializeWorkspace() {
        this.ERROR = new double[this.Z.length];
        this.DERIVATIVES = new double[this.Z.length][this.A.length];
    }

    @Override
    public void fitData() {
        this.initializeWorkspace();
        try {
            this.iterateValues();
        }
        catch (Exception exc) {
            this.printMatrix();
            exc.printStackTrace();
            throw new RuntimeException(exc);
        }
    }

    @Override
    public double[] getParameters() {
        return this.A;
    }

    @Override
    public double[] getUncertainty() {
        Matrix a_matrix = new Matrix(this.ALPHA);
        Matrix b = a_matrix.inverse();
        double[] residuals = new double[this.A.length];
        double error = this.calculateErrors() / (double)this.Z.length;
        for (int i = 0; i < this.A.length; ++i) {
            residuals[i] = Math.sqrt(b.get(i, i) * error);
        }
        return residuals;
    }

    public double[][] getCovarianceMatrix() {
        Matrix a_matrix = new Matrix(this.ALPHA);
        Matrix b = a_matrix.inverse();
        double error = this.calculateErrors() / (double)this.Z.length;
        double[][] ret = new double[this.A.length][this.A.length];
        for (int i = 0; i < this.A.length; ++i) {
            for (int j = 0; j < this.A.length; ++j) {
                ret[i][j] = b.get(i, j) * error;
            }
        }
        return ret;
    }
}

