/*
 * Decompiled with CFR 0.152.
 */
package org.orangepalantir.leastsquares.fitters;

import Jama.Matrix;
import org.orangepalantir.leastsquares.Fitter;
import org.orangepalantir.leastsquares.Function;

public class MarquardtFitter
implements Fitter {
    double[][] X;
    double[] A;
    double[] Z;
    Function FUNCTION;
    double[] ERROR;
    double[][] DERIVATIVES;
    double[][] ALPHA_PRIME;
    double[] LAMBDA;
    double[] BETA;
    double DELTA = 1.0E-6;
    double MINERROR = 1.0E-9;
    double MINCHANGE = 0.001;
    public int ITERATIONS = 0;

    public MarquardtFitter(Function funct) {
        this.FUNCTION = funct;
    }

    @Override
    public void setData(double[][] xvalues, double[] zvalues) {
        if (xvalues.length != zvalues.length) {
            throw new IllegalArgumentException("there must be 1 z value for each set of x values");
        }
        if (xvalues[0].length != this.FUNCTION.getNInputs()) {
            throw new IllegalArgumentException("The length of parameters is longer that the parameters accepted by the function");
        }
        this.X = xvalues;
        this.Z = zvalues;
    }

    @Override
    public void setParameters(double[] parameters) {
        if (parameters.length != this.FUNCTION.getNParameters()) {
            throw new IllegalArgumentException("the number of parameters must equal the required number for the function: " + this.FUNCTION.getNParameters());
        }
        this.A = new double[parameters.length];
        System.arraycopy(parameters, 0, this.A, 0, parameters.length);
    }

    @Override
    public double calculateErrors() {
        double new_error = 0.0;
        for (int i = 0; i < this.Z.length; ++i) {
            double v = this.FUNCTION.evaluate(this.X[i], this.A);
            this.ERROR[i] = this.Z[i] - v;
            new_error += Math.pow(this.ERROR[i], 2.0);
        }
        return new_error;
    }

    public double calculateDerivative(int k, double[] params, double[] x) {
        int n = k;
        params[n] = params[n] - this.DELTA;
        double b = this.FUNCTION.evaluate(x, params);
        int n2 = k;
        params[n2] = params[n2] + 2.0 * this.DELTA;
        double a = this.FUNCTION.evaluate(x, params);
        int n3 = k;
        params[n3] = params[n3] - this.DELTA;
        return (a - b) / (2.0 * this.DELTA);
    }

    public void calculateDerivatives() {
        double[] working = new double[this.A.length];
        System.arraycopy(this.A, 0, working, 0, this.A.length);
        for (int j = 0; j < this.A.length; ++j) {
            for (int i = 0; i < this.Z.length; ++i) {
                this.DERIVATIVES[i][j] = this.calculateDerivative(j, working, this.X[i]);
            }
        }
    }

    public double calculateSecondDerivative(int l, int k, double[] params, double[] x) {
        int n = l;
        params[n] = params[n] - this.DELTA;
        double b = this.calculateDerivative(k, params, x);
        int n2 = l;
        params[n2] = params[n2] + 2.0 * this.DELTA;
        double a = this.calculateDerivative(k, params, x);
        int n3 = l;
        params[n3] = params[n3] - this.DELTA;
        return (a - b) / (2.0 * this.DELTA);
    }

    public void createBetaMatrix() {
        this.BETA = new double[this.A.length];
        double[] working = new double[this.A.length];
        System.arraycopy(this.A, 0, working, 0, this.A.length);
        for (int k = 0; k < this.BETA.length; ++k) {
            for (int i = 0; i < this.X.length; ++i) {
                int n = k;
                this.BETA[n] = this.BETA[n] + this.ERROR[i] * this.DERIVATIVES[i][k];
            }
        }
    }

    public void createAlphaPrimeMatrix() {
        this.ALPHA_PRIME = new double[this.A.length][this.A.length];
        int n = this.A.length;
        for (int k = 0; k < n; ++k) {
            for (int l = 0; l < n; ++l) {
                for (int i = 0; i < this.X.length; ++i) {
                    double[] dArray = this.ALPHA_PRIME[l];
                    int n2 = k;
                    dArray[n2] = dArray[n2] + this.DERIVATIVES[i][k] * this.DERIVATIVES[i][l];
                }
                if (k != l) continue;
                this.ALPHA_PRIME[l][k] = this.ALPHA_PRIME[l][k] * (1.0 + this.LAMBDA[k]);
            }
        }
    }

    public void iterateValues() {
        this.calculateDerivatives();
        this.createBetaMatrix();
        this.createAlphaPrimeMatrix();
        Matrix alpha_matrix = new Matrix(this.ALPHA_PRIME);
        Matrix beta = new Matrix(this.BETA, this.BETA.length);
        Matrix out = alpha_matrix.solve(beta);
        double[][] delta_a = out.getArray();
        for (int i = 0; i < this.A.length; ++i) {
            int n = i;
            this.A[n] = this.A[n] + delta_a[i][0];
        }
    }

    public void initializeWorkspace() {
        this.ERROR = new double[this.Z.length];
        this.DERIVATIVES = new double[this.Z.length][this.A.length];
        this.LAMBDA = new double[this.A.length];
        for (int i = 0; i < this.A.length; ++i) {
            this.LAMBDA[i] = 0.01;
        }
    }

    @Override
    public void fitData() {
        this.initializeWorkspace();
        double error = this.calculateErrors();
        double[] acopy = new double[this.A.length];
        for (int i = 0; i < 10000; ++i) {
            try {
                System.arraycopy(this.A, 0, acopy, 0, this.A.length);
                this.iterateValues();
            }
            catch (Exception exc) {
                System.out.println("Broke after " + i + " iterations");
                this.printMatrix();
                throw new RuntimeException(exc);
            }
            double nerror = this.calculateErrors();
            double value = error - nerror;
            if (value < 0.0) {
                System.arraycopy(acopy, 0, this.A, 0, acopy.length);
                this.updateLambda(value);
                nerror = this.calculateErrors();
            } else if (value < 1.0E-4) {
                this.ITERATIONS = i;
                break;
            }
            error = nerror;
        }
    }

    public void updateLambda(double value) {
        if (value < 0.0) {
            for (int i = 0; i < this.LAMBDA.length; ++i) {
                this.LAMBDA[i] = this.LAMBDA[i] * 10.0;
            }
        } else {
            for (int i = 0; i < this.LAMBDA.length; ++i) {
                this.LAMBDA[i] = this.LAMBDA[i] * 0.1;
            }
        }
    }

    @Override
    public double[] getParameters() {
        return this.A;
    }

    @Override
    public double[] getUncertainty() {
        return new double[0];
    }

    public String printMatrix() {
        String message = "";
        for (int i = 0; i < this.ALPHA_PRIME.length; ++i) {
            for (int j = 0; j < this.ALPHA_PRIME[0].length; ++j) {
                message = message + this.ALPHA_PRIME[i][j] + "\t";
            }
            message = message + "| " + this.BETA[i] + "\n";
        }
        return message;
    }
}

